package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotRegionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotRegionImportRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
    * @Descrption: 广告位地域类型操作接口
    * @author: miaohongshuai
    * @Date: 2019/4/10
*/
@AdvancedFeignClient
public interface RemoteSlotRegionService {

    /**
     * 根据广告位ID获取地域类型列表
     * @param slotId
     * @return
     */
    List<SlotRegionDto> selectBySlotId(Long slotId);

    /**
     * 新增地域类型
     * @param slotRegionDto
     * @return
     */
    DubboResult<Long> saveRegion(SlotRegionDto slotRegionDto);

    /**
     * 更新地域类型
     * @param slotRegionDto
     * @return
     */
    DubboResult<Integer> updateRegion(SlotRegionDto slotRegionDto);

    /**
     * 删除地域类型
     * @param regionIds
     * @return
     */
    int deleteRegion(List<Long> regionIds);

    /**
     * 导入地域类型
     * @param cityNameList 城市名称列表
     * @return
     */
    SlotRegionImportRsp importSlotRegion(List<String> cityNameList);

    /**
     * 获取广告位的默认地域类型
     * @param slotId
     * @return
     */
    SlotRegionDto getDefRegion(Long slotId);
}
