package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActRatioView;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityRatioDto;
import cn.com.duiba.tuia.ssp.center.api.dto.GroupRatioDayuDto;
import cn.com.duiba.tuia.ssp.center.api.params.UvActivityRatioReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteActRatioService {
	
	String updateFlowRatio(Long slotId, Integer isOpen, Integer ratio);

	/**
	 * 更新算法切量比例
	 * @param slotId
	 * @param algoFlowStatus
	 * @param algoSplitRatio
	 * @return
	 */
	String updateAlgoFlowRatio(Long slotId, Byte algoFlowStatus, Byte algoSplitRatio,Byte origin);
	/**
	 * 添加活动组
	 * @param slotId
	 * @param actId
	 * @param actSource
	 * @return
	 */
	Long addGroup(Long slotId, Long actId, Integer actSource);
	/**
	 * 活动组活动展示
	 * @param slotId
	 * @return
	 */
	ActRatioView listAct4Slot(Long slotId);
	/**
	 * 活动组活动
	 * @param slotId
	 * @return
	 */
	List<ActivityRatioDto> listAct4Dayu(Long slotId);
	/**
	 * 添加活动
	 * @param record
	 */
	String addAct(ActivityRatioDto record);
	/**
	 * 获取场景id
	 * @param slotId
	 * @return
	 */
	Long getSceneId(Long slotId);
	/**
	 * 保存场景id
	 * @param slotId
	 * @param sceneId
	 * @return
	 */
	Integer createSceneId(Long slotId, Long sceneId);
	/**
	 * 删除活动
	 * @param record
	 */
	void delAct(ActivityRatioDto record);
	/**
	 * 删除活动组
	 * @param actGroupId
	 */
	void delGroup(Long slotId, Long actGroupId);
	/**
	 * 修改比例
	 * @param record
	 */
	String updateActRatio(ActivityRatioDto record);
	/**
	 * 修改排序
	 * @param slotId
	 * @param actGroupId
	 * @param location
	 */
	void sort(Long slotId, Long actGroupId, Integer location);
	/**
	 * 引擎获取定制列表
	 * @param slotId
	 * @return
	 */
	GroupRatioDayuDto getDeliveryAct(Long slotId);

	/**
	 * 活动组设置默认活动
	 */
	Boolean setDefault(ActivityRatioDto record);

	/**
	 * 活动替换
	 */
	void changeActivityId(boolean rollback);

	void replaceActivityId(Long oldActivityId, Long newActivityId);

	void replaceActivityByActSource(Long oldActivityId, Long newActivityId,Integer actSource);

	/**
	 * UV分流添加活动
	 *
	 * @param req
	 */
	int addUvAct(UvActivityRatioReq req);

	/**
	 * 按地域添加活动组
	 * @param activityRatioDto
	 * @return
	 */
	Long addGroupByRegion(ActivityRatioDto activityRatioDto);

	/**
	 * 按地域活动组活动展示
	 * @param slotId
	 * @return
	 */
	ActRatioView listAct4SlotByRegion(Long slotId, Long regionId);

	/**
	 * 按地域删除活动组
	 * @param slotId 广告位ID
	 * @param regionId 地域类型ID
	 * @param actGroupId 活动组ID
	 * @return
	 */
	void delGroupByRegion(Long slotId, Long regionId, Long actGroupId);

	/**
	 * 修改排序
	 * @param slotId 广告位ID
	 * @param regionId 地域类型ID
	 * @param actGroupId 活动组ID
	 * @param location 位置
	 */
	void sortByRegion(Long slotId, Long regionId, Long actGroupId, Integer location);

	/**
	 * 引擎获取定制列表
	 * @param slotId 广告位ID
	 * @param regionId 地域类型ID
	 * @return
	 */
	GroupRatioDayuDto getDeliveryActByRegion(Long slotId, Long regionId);

    String getActivityUrlByDto(ActivityRatioDto activityRatioDto);
}
