package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.NumberFormat;

import java.io.Serializable;
import java.util.List;

@ApiModel
public class MediaRewardDataDto extends RewardScoreBase implements Serializable {

    /**
     * 序列号
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "今日预计得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double scoreToday;

    @ApiModelProperty(value = "昨日预计得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double scoreYesToday;

    @ApiModelProperty(value = "上月预计得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double scoreYesMonth;

    @ApiModelProperty(value = "上季预计得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double scoreYesQuarter;

    @ApiModelProperty(value = "上月收入")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long incomeYesMonth;

    @ApiModelProperty(value = "上季收入")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long incomeYesQuarter;

    @ApiModelProperty(value = "上月目标")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long targetYesMonth;

    @ApiModelProperty(value = "上季目标")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long targetYesQuarter;

    @ApiModelProperty(value = "本周期收入")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long incomeToCycle;

    @ApiModelProperty(value = "本周期目标")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Long targetToCycle;

    @ApiModelProperty(value = "奖励规则列表")
    private List<MediaRewardStrategyDto.RewardRule> rrList;

    @ApiModelProperty(value = "奖励规则类型 1季度|0月度")
    private Integer type;

    @ApiModelProperty(value = "当前时间是否有奖励规则 true没有|false有")
    private boolean showModal;

    @ApiModelProperty(value = "完成率下限")
    private Double lowerLimitRate;

    @ApiModelProperty(value = "昨日预计季度得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double quarterScoreYesToday;

    @ApiModelProperty(value = "今日预计季度得分")
    @NumberFormat(style= NumberFormat.Style.CURRENCY)
    private Double quarterScoreToday;

    public Double getScoreToday() {
        return scoreToday;
    }

    public void setScoreToday(Double scoreToday) {
        this.scoreToday = scoreToday;
    }


    public Double getScoreYesToday() {
        return scoreYesToday;
    }

    public void setScoreYesToday(Double scoreYesToday) {
        this.scoreYesToday = scoreYesToday;
    }

    public Double getScoreYesMonth() {
        return scoreYesMonth;
    }

    public void setScoreYesMonth(Double scoreYesMonth) {
        this.scoreYesMonth = scoreYesMonth;
    }

    public Double getScoreYesQuarter() {
        return scoreYesQuarter;
    }

    public void setScoreYesQuarter(Double scoreYesQuarter) {
        this.scoreYesQuarter = scoreYesQuarter;
    }

    public Long getIncomeYesMonth() {
        return incomeYesMonth;
    }

    public void setIncomeYesMonth(Long incomeYesMonth) {
        this.incomeYesMonth = incomeYesMonth;
    }

    public Long getIncomeYesQuarter() {
        return incomeYesQuarter;
    }

    public void setIncomeYesQuarter(Long incomeYesQuarter) {
        this.incomeYesQuarter = incomeYesQuarter;
    }

    public Long getTargetYesMonth() {
        return targetYesMonth;
    }

    public void setTargetYesMonth(Long targetYesMonth) {
        this.targetYesMonth = targetYesMonth;
    }

    public Long getTargetYesQuarter() {
        return targetYesQuarter;
    }

    public void setTargetYesQuarter(Long targetYesQuarter) {
        this.targetYesQuarter = targetYesQuarter;
    }

    public Long getIncomeToCycle() {
        return incomeToCycle;
    }

    public void setIncomeToCycle(Long incomeToCycle) {
        this.incomeToCycle = incomeToCycle;
    }

    public Long getTargetToCycle() {
        return targetToCycle;
    }

    public void setTargetToCycle(Long targetToCycle) {
        this.targetToCycle = targetToCycle;
    }

    public List<MediaRewardStrategyDto.RewardRule> getRrList() {
        return rrList;
    }

    public void setRrList(List<MediaRewardStrategyDto.RewardRule> rrList) {
        this.rrList = rrList;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public void setShowModal(boolean showModal) {
        this.showModal = showModal;
    }

    public Double getLowerLimitRate() {
        return lowerLimitRate;
    }

    public void setLowerLimitRate(Double lowerLimitRate) {
        this.lowerLimitRate = lowerLimitRate;
    }

    public boolean isShowModal() {
        return showModal;
    }

    public void setQuarterScoreYesToday(Double quarterScoreYesToday) {
        this.quarterScoreYesToday = quarterScoreYesToday;
    }

    public Double getQuarterScoreYesToday() {
        return quarterScoreYesToday;
    }

    public void setQuarterScoreToday(Double quarterScoreToday) {
        this.quarterScoreToday = quarterScoreToday;
    }

    public Double getQuarterScoreToday() {
        return quarterScoreToday;
    }
}
