/**
 * Project Name:media-manager-biz File Name:ReqMaterialStatis.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2017年3月14日下午4:04:27 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMaterialStatis <br/>
 * Function: 以活动素材维度统计广告位查询. <br/>
 * Date: 2017年3月14日 下午4:04:27 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqMaterialSlotStatistics extends ReqMaterialStatisticsBase {

    /** 序列号 */
    private static final long serialVersionUID = 2602776111753942620L;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 广告位名称 */
    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    /** slotIds */
    @ApiModelProperty(value = "广告位IDS", required = false)
    private List<Long>        slotIds;

    /** appIds */
    @ApiModelProperty(value = "媒体IDS", required = false)
    private List<Long>        appIds;

    /** 活动名称 */
    @ApiModelProperty(value = "活动名称", required = false)
    private String            activityName;

    /** 活动IDS */
    @ApiModelProperty(value = "活动IDS", required = false)
    private List<Long>        activityIds;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
