/**
 * Project Name:media-api File Name:RspSlotDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:20:08 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspSlotDataStatisticsDto <br/>
 * Function: 广告数据统计Dto. <br/>
 * Date: 2016年10月13日 下午8:20:08 <br/>
 * 
 * @author guayn
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotDataStatisticsDto implements Serializable {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -7019648321036508754L;

    /**
     * 广告位ID.
     */
    private Long slotId;

    /**
     * 广告位名称.
     */
    private String slotName;

    /**
     * 广告位类型.
     */
    private Integer slotType;

    /**
     * 广告位规格名称
     */
    private String msName;

    /**
     * 曝光量.
     */
    private Long exposureCount;

    /**
     * 点击率
     */
    private Float clickRate;

    /**
     * 点击数.
     */
    private Long clickCount;

    /**
     * 预计收入.
     */
    private Long consumeTotal;

    /**
     * 预计收入.
     */
    private Long hzConsumeTotal;

    /**
     * 预计收入.
     */
    private Long hegsConsumeTotal;

    /**
     * 每一千次的有效价格.
     */
    private Long eCpm;

    /**
     * 点击单价.
     */
    private Long cpc;

    /**
     * 广告位成功响应数量
     */
    private Long actSucResponseCount;

    /**
     * 广告位访问pv
     */
    private Long slotRequestPv;

    /**
     * 广告位访问uv
     */
    private Long slotRequestUv;

    private Integer modifyStatus;

    /* ip访问量*/
    private Long ipRequestPvCount;

    /*  新客访问量(UV)  */
    private Long newRequestUvCount;

    /**
     * 媒体cpc=预计收益/点击量
     */
    private Long mediaCpc;
    /**
     * 媒体cpm=预计收益*1000/曝光量
     */
    private Long mediaCpm;
    /**
     * 每UV收益=预计收益/广告位访问UV
     */
    private Long mediaUvPrice;


    /**
     * 活动访问uv
     */
    private Long actRequestUv;


    /**
     * 次日留存
     */
    private Long morrowRetention;

    /**
     * 三日留存
     */
    private Long threeDaysRetention;

    /**
     * 七日留存
     */
    private Long sevenDaysRetention;


    /**
     * 三日ltv
     */
    private Long threeDaysLtv;

    /**
     *参与uv
     */
    private Long activityParticipationUv;


    /**
     * 参与率
     */
    private Float participationRate;


    /**
     * 查询区间结束日期广告位访问uv
     */
    private Long slotRequestUvEndDate;


    public Long getIpRequestPvCount() {
        return ipRequestPvCount;
    }

    public void setIpRequestPvCount(Long ipRequestPvCount) {
        this.ipRequestPvCount = ipRequestPvCount;
    }

    public Long getNewRequestUvCount() {
        return newRequestUvCount;
    }

    public void setNewRequestUvCount(Long newRequestUvCount) {
        this.newRequestUvCount = newRequestUvCount;
    }

    /**
     * geteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public Long geteCpm() {
        return eCpm;
    }

    /**
     * seteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param eCpm
     * @author ZFZ
     * @since JDK 1.6
     */
    public void seteCpm(Long eCpm) {
        this.eCpm = eCpm;
    }

    /**
     * getCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public Long getCpc() {
        return cpc;
    }

    /**
     * setCpc:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param cpc
     * @author ZFZ
     * @since JDK 1.6
     */
    public void setCpc(Long cpc) {
        this.cpc = cpc;
    }

    /**
     * getSlotId:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * setSlotId:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param slotId
     * @author ZFZ
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * getSlotName:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * setSlotName:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param slotName
     * @author ZFZ
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * getSlotType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * setSlotType:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param slotType
     * @author ZFZ
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * getConsumeTotal:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author ZFZ
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * setConsumeTotal:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param consumeTotal
     * @author ZFZ
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public Float getClickRate() {
        return clickRate;
    }

    /**
     * msName.
     *
     * @param clickRate the msName to set
     * @since JDK 1.6
     */
    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * msName.
     *
     * @return the msName
     * @since JDK 1.6
     */
    public String getMsName() {
        return msName;
    }

    /**
     * clickRate.
     *
     * @param msName the clickRate to set
     * @since JDK 1.6
     */
    public void setMsName(String msName) {
        this.msName = msName;
    }

    /**
     * actSucResponseCount.
     *
     * @return the actSucResponseCount
     * @since JDK 1.6
     */
    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    /**
     * actSucResponseCount.
     *
     * @param actSucResponseCount the actSucResponseCount to set
     * @since JDK 1.6
     */
    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }

    /**
     * slotRequestPv.
     *
     * @return the slotRequestPv
     * @since JDK 1.6
     */
    public Long getSlotRequestPv() {
        return slotRequestPv;
    }

    /**
     * slotRequestPv.
     *
     * @param slotRequestPv the slotRequestPv to set
     */
    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    /**
     * slotRequestUv.
     *
     * @return the slotRequestUv
     * @since JDK 1.6
     */
    public Long getSlotRequestUv() {
        return slotRequestUv;
    }

    /**
     * slotRequestUv.
     *
     * @param slotRequestUv the slotRequestUv to set
     */
    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

    public Integer getModifyStatus() {
        return modifyStatus;
    }

    public void setModifyStatus(Integer modifyStatus) {
        this.modifyStatus = modifyStatus;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getMediaCpc() {
        return mediaCpc;
    }

    public void setMediaCpc(Long mediaCpc) {
        this.mediaCpc = mediaCpc;
    }

    public Long getMediaCpm() {
        return mediaCpm;
    }

    public void setMediaCpm(Long mediaCpm) {
        this.mediaCpm = mediaCpm;
    }

    public Long getMediaUvPrice() {
        return mediaUvPrice;
    }

    public void setMediaUvPrice(Long mediaUvPrice) {
        this.mediaUvPrice = mediaUvPrice;
    }

    public Long getActRequestUv() {
        return actRequestUv;
    }

    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    public Long getMorrowRetention() {
        return morrowRetention;
    }

    public void setMorrowRetention(Long morrowRetention) {
        this.morrowRetention = morrowRetention;
    }

    public Long getThreeDaysRetention() {
        return threeDaysRetention;
    }

    public void setThreeDaysRetention(Long threeDaysRetention) {
        this.threeDaysRetention = threeDaysRetention;
    }

    public Long getSevenDaysRetention() {
        return sevenDaysRetention;
    }

    public void setSevenDaysRetention(Long sevenDaysRetention) {
        this.sevenDaysRetention = sevenDaysRetention;
    }

    public Long getThreeDaysLtv() {
        return threeDaysLtv;
    }

    public void setThreeDaysLtv(Long threeDaysLtv) {
        this.threeDaysLtv = threeDaysLtv;
    }


    public Float getParticipationRate() {
        return participationRate;
    }

    public void setParticipationRate(Float participationRate) {
        this.participationRate = participationRate;
    }

    public Long getActivityParticipationUv() {
        return activityParticipationUv;
    }

    public void setActivityParticipationUv(Long activityParticipationUv) {
        this.activityParticipationUv = activityParticipationUv;
    }

    public Long getSlotRequestUvEndDate() {
        return slotRequestUvEndDate;
    }

    public void setSlotRequestUvEndDate(Long slotRequestUvEndDate) {
        this.slotRequestUvEndDate = slotRequestUvEndDate;
    }

    /**
     * 排序
     *
     * @param param
     * @param slotDataStatisticsList
     * @return
     */
    public static List<RspSlotDataStatisticsDto> listSort(ReqSlotLineStatisticsByPageDto param, List<RspSlotDataStatisticsDto> slotDataStatisticsList) {  //NOSONAR
        String sort = param.getSort();
        String order = param.getOrder();
        if (Objects.nonNull(sort) && Objects.nonNull(order)) {
            formatList(sort,slotDataStatisticsList);
            switch (sort) {
                case "exposureCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getExposureCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getExposureCount)).collect(Collectors.toList());
                    }
                case "clickCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getClickCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getClickCount)).collect(Collectors.toList());
                    }
                case "clickRate":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingDouble(RspSlotDataStatisticsDto::getClickRate).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingDouble(RspSlotDataStatisticsDto::getClickRate)).collect(Collectors.toList());
                    }
                case "consumeTotal":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getConsumeTotal).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getConsumeTotal)).collect(Collectors.toList());
                    }
                case "slotRequestPv":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getSlotRequestUv).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getSlotRequestUv)).collect(Collectors.toList());
                    }
                case "slotRequestUv":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getSlotRequestUv).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getSlotRequestUv)).collect(Collectors.toList());
                    }
                case "ipRequestPvCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getIpRequestPvCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getIpRequestPvCount)).collect(Collectors.toList());
                    }
                case "newRequestUvCount":

                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getNewRequestUvCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getNewRequestUvCount)).collect(Collectors.toList());
                    }
                case "mediaCpc":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaCpc).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaCpc)).collect(Collectors.toList());
                    }
                case "mediaCpm":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaCpm).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaCpm)).collect(Collectors.toList());
                    }
                case "mediaUvPrice":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaUvPrice).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspSlotDataStatisticsDto::getMediaUvPrice)).collect(Collectors.toList());
                    }
                default:
                    break;
            }
        }
        return slotDataStatisticsList;
    }

    /**
     * 格式化数据
     *
     * @param sort
     * @param slotDataStatisticsList
     */
    private static void formatList(String sort, List<RspSlotDataStatisticsDto> slotDataStatisticsList) { //NOSONAR
        switch (sort) {
            case "exposureCount":
                slotDataStatisticsList.stream().forEach(o -> o.setExposureCount(Objects.isNull(o.getExposureCount()) ? 0 : o.getExposureCount()));
                break;
            case "clickCount":
                slotDataStatisticsList.stream().forEach(o -> o.setClickCount(Objects.isNull(o.getClickCount()) ? 0 : o.getClickCount()));
                break;
            case "clickRate":
                slotDataStatisticsList.stream().forEach(o -> o.setClickRate(Objects.isNull(o.getClickRate()) ? 0 : o.getClickRate()));
                break;
            case "consumeTotal":
                slotDataStatisticsList.stream().forEach(o -> o.setConsumeTotal(Objects.isNull(o.getConsumeTotal()) ? 0 : o.getConsumeTotal()));
                break;
            case "slotRequestPv":
                slotDataStatisticsList.stream().forEach(o -> o.setSlotRequestPv(Objects.isNull(o.getSlotRequestPv()) ? 0 : o.getSlotRequestPv()));
                break;
            case "slotRequestUv":
                slotDataStatisticsList.stream().forEach(o -> o.setSlotRequestUv(Objects.isNull(o.getSlotRequestUv()) ? 0 : o.getSlotRequestUv()));
                break;
            case "ipRequestPvCount":
                slotDataStatisticsList.stream().forEach(o -> o.setIpRequestPvCount(Objects.isNull(o.getIpRequestPvCount()) ? 0 : o.getIpRequestPvCount()));
                break;
            case "newRequestUvCount":
                slotDataStatisticsList.stream().forEach(o -> o.setNewRequestUvCount(Objects.isNull(o.getNewRequestUvCount()) ? 0 : o.getNewRequestUvCount()));
                break;
            case "mediaCpc":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaCpc(Objects.isNull(o.getMediaCpc()) ? 0 : o.getMediaCpc()));
                break;
            case "mediaCpm":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaCpm(Objects.isNull(o.getMediaCpm()) ? 0 : o.getMediaCpm()));
                break;
            case "mediaUvPrice":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaUvPrice(Objects.isNull(o.getMediaUvPrice()) ? 0 : o.getMediaUvPrice()));
                break;
            default:
                break;
        }

    }
}
