package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.media.rsp;

import cn.com.duiba.tuia.core.api.dto.MediaMaterialDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 行业标签策略下广告详情
 *
 * @author hillchen
 * @create 2018/10/28 22:55
 */
@ApiModel(value = "行业标签策略下广告详情模型")
public class BuzTagAdvertInfoRsp implements Serializable {
    private static final long serialVersionUID = 1214654012451779932L;
    /**
     * 广告id
     */
    private Long id;

    /**
     *
     * 广告名称
     */
    private String name;

    private String tagCode;

    /**
     * 广告状态
     */
    private int advertValidStatus;

    /**
     * 广告素材
     */
    private List<String> materialUrls;

    /**
     * 广告落地页
     */
    private List<String> promotionUrls;

    /**
     * 是否新广告
     */
    private boolean isNewAdvert;


    /**
     * 广告素材 包括：1.默认优惠券名称 2.动态优惠券名称 3.素材图片链接
     */
    private List<MediaMaterialDto> materialList;

    /**
     * @Author zhangliwei
     * @Description  包含审核状态的广告素材列表
     * @Date 13:58 2019-06-24
     * @Param
     * @return
     **/
    private List<AuditedMaterialDto> auditedMaterialList;

    /**
     * @Author zhangliwei
     * @Description   选中素材数量
     * @Date 11:24 2019-06-19
     **/
    private Integer selectedMaterialNum;

    /**
     * @Author zhangliwei
     * @Description   选中素材数量
     * @Date 11:24 2019-06-19
     **/
    private Integer totalMaterialNum;

    /**
     * @Author zhangliwei
     * @Description   广告下是否有可用素材
     * @Date 11:24 2019-06-19
     **/
    @ApiModelProperty(value = "广告下是否有审核通过素材标志")
    private boolean avaliableFlag;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAdvertValidStatus() {
        return advertValidStatus;
    }

    public void setAdvertValidStatus(int advertValidStatus) {
        this.advertValidStatus = advertValidStatus;
    }

    public List<String> getMaterialUrls() {
        return materialUrls;
    }

    public void setMaterialUrls(List<String> materialUrls) {
        this.materialUrls = materialUrls;
    }

    public List<String> getPromotionUrls() {
        return promotionUrls;
    }

    public void setPromotionUrls(List<String> promotionUrls) {
        this.promotionUrls = promotionUrls;
    }

    public boolean isNewAdvert() {
        return isNewAdvert;
    }

    public void setNewAdvert(boolean newAdvert) {
        isNewAdvert = newAdvert;
    }

    public String getTagCode() {
        return tagCode;
    }

    public void setTagCode(String tagCode) {
        this.tagCode = tagCode;
    }

    public List<MediaMaterialDto> getMaterialList() {
        return materialList;
    }

    public void setMaterialList(List<MediaMaterialDto> materialList) {
        this.materialList = materialList;
    }

    public Integer getSelectedMaterialNum() {
        return selectedMaterialNum;
    }

    public void setSelectedMaterialNum(Integer selectedMaterialNum) {
        this.selectedMaterialNum = selectedMaterialNum;
    }

    public Integer getTotalMaterialNum() {
        return totalMaterialNum;
    }

    public void setTotalMaterialNum(Integer totalMaterialNum) {
        this.totalMaterialNum = totalMaterialNum;
    }

    public boolean isAvaliableFlag() {
        return avaliableFlag;
    }

    public void setAvaliableFlag(boolean avaliableFlag) {
        this.avaliableFlag = avaliableFlag;
    }

    public List<AuditedMaterialDto> getAuditedMaterialList() {
        return auditedMaterialList;
    }

    public void setAuditedMaterialList(List<AuditedMaterialDto> auditedMaterialList) {
        this.auditedMaterialList = auditedMaterialList;
    }
}