/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool.idsquery;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class IdsQueryParam
implements Serializable {
    private static final long serialVersionUID = 4724027435815659587L;
    private Set<Long> ids;
    private boolean needQuery;

    public boolean isNeedQuery() {
        return this.needQuery;
    }

    public void setNeedQuery(boolean needQuery) {
        this.needQuery = needQuery;
    }

    public Set<Long> getIds() {
        return this.ids;
    }

    public void setIds(Set<Long> ids) {
        this.ids = ids;
    }

    public void mixedId(final Long id) {
        if (id != null) {
            this.mixedIds(new HashSet(){
                {
                    this.add(id);
                }
            });
        }
    }

    public void mixedIds(Collection<Long> mixedIds) {
        if (this.needQuery && CollectionUtils.isNotEmpty(mixedIds)) {
            if (CollectionUtils.isNotEmpty(this.ids)) {
                Collection addIds = CollectionUtils.intersection(this.ids, mixedIds);
                this.ids = new HashSet<Long>(addIds);
                this.needQuery = CollectionUtils.isNotEmpty((Collection)addIds);
            } else {
                this.ids = new HashSet<Long>(mixedIds);
            }
        }
    }

    public void mixedIds(IdsQueryParam idsQueryParam) {
        if (idsQueryParam.isNeedQuery()) {
            this.mixedIds(idsQueryParam.getIds());
        } else {
            this.needQuery = false;
        }
    }

    public boolean notUnlimited() {
        return CollectionUtils.isNotEmpty(this.getIds());
    }

    public static IdsQueryParam allQueryParam() {
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        return idsQueryParam;
    }

    public static IdsQueryParam dontQueryParam() {
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(false);
        return idsQueryParam;
    }

    public static IdsQueryParam buildIdsQuery(Long id) {
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(id);
        idsQueryParam.setIds(ids);
        return idsQueryParam;
    }

    public static IdsQueryParam buildIdsQuery(Set<Long> ids) {
        IdsQueryParam idsQueryParam = new IdsQueryParam();
        idsQueryParam.setNeedQuery(true);
        HashSet<Long> queryIds = new HashSet<Long>();
        idsQueryParam.setIds(queryIds);
        if (CollectionUtils.isNotEmpty(ids)) {
            queryIds.addAll(ids);
        }
        return idsQueryParam;
    }
}

