/**
 * Project Name:media-biz File Name:AccountSettlementDto.java Package Name:cn.com.duiba.tuia.media.domain
 * Date:2016年12月4日下午5:48:48 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:AccountSettlementDto <br/>
 * Function: 媒体用户结算. <br/>
 * Date: 2016年12月4日 下午5:48:48 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class AccountSettlementDto extends BaseDto {

    /** 序列号 */
    private static final long serialVersionUID            = -2303068775573177460L;

    /** 待结算状态 */
    public static final int   SETTLEMENTS_STATUS_AWAITING = 0;
    /** 结算中状态 */
    public static final int   SETTLEMENT_STATUS_DEFAULT   = 1;
    /** 拒绝结算状态 */
    public static final int   SETTLEMENT_STATUS_REFUSED   = 2;
    /** 已结算状态 */
    public static final int   SETTLEMENT_STATUS_PASS      = 3;

    /** 审核状态通过 */
    public static final int   AUDIT_STATUS_PASS           = 1;
    /** 审核状态拒绝 */
    public static final int   AUDIT_STATUS_REFUSED        = 0;
    
    /** 杭州最终收入 */
    public static final int   HZ_SETTLED_MEDIA_DIVIDE     = 0;

    /** 霍尔果斯最终收入 */
    public static final int   HEGS_SETTLED_MEDIA_DIVIDE   = 1;

    /** 媒体用户id */
    private Long              mediaId;
    /** 媒体id */
    private Long              appId;
    /** 结算月份 */
    private Date              settledDate;
    /** 结算后媒体分成 */
    private Long              settledMediaDivide;
    /** 金額 */
    private Long              amount;

    /** 管理后台展示备注 */
    private String            remark;

    /** 业务平台展示备注 */
    private String            businessRemark;

    /** 结算状态：0-待结算，1-结算中，2-拒绝结算  3-已结算*/
    private Integer           settlementStatus;
    /** 审核状态：0-通过，1-拒绝 */
    private Integer           auditStatus;
    /** 结算人姓名 */
    private String            settlementPersonName;
    /** 月报表Id */
    private Long              reportId;
    /** 线下打款金额 */
    private Long              offlineMoney;
    /**杭州结算后媒体分成*/
    private Long              hzSettledMediaDivide;

    /**霍尔果斯结算后媒体分成*/
    private Long              hegsSettledMediaDivide;
    /** 调整金额 */
    private Long             adjustMoney;
    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * settledDate.
     *
     * @return the settledDate
     * @since JDK 1.6
     */
    public Date getSettledDate() {
        return settledDate;
    }

    /**
     * settledDate.
     *
     * @param settledDate the settledDate to set
     * @since JDK 1.6
     */
    public void setSettledDate(Date settledDate) {
        this.settledDate = settledDate;
    }

    /**
     * settledMediaDivide.
     *
     * @return the settledMediaDivide
     * @since JDK 1.6
     */
    public Long getSettledMediaDivide() {
        return settledMediaDivide;
    }

    /**
     * settledMediaDivide.
     *
     * @param settledMediaDivide the settledMediaDivide to set
     * @since JDK 1.6
     */
    public void setSettledMediaDivide(Long settledMediaDivide) {
        this.settledMediaDivide = settledMediaDivide;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.6
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.6
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * settlementStatus.
     *
     * @param settlementStatus the settlementStatus to set
     * @since JDK 1.6
     */
    public void setSettlementStatus(Integer settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    /**
     * auditStatus.
     *
     * @return the auditStatus
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    /**
     * settlementPersonName.
     *
     * @return the settlementPersonName
     * @since JDK 1.6
     */
    public String getSettlementPersonName() {
        return settlementPersonName;
    }

    /**
     * settlementPersonName.
     *
     * @param settlementPersonName the settlementPersonName to set
     * @since JDK 1.6
     */
    public void setSettlementPersonName(String settlementPersonName) {
        this.settlementPersonName = settlementPersonName;
    }

    /**
     * amount.
     *
     * @return the amount
     * @since JDK 1.6
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * amount.
     *
     * @param amount the amount to set
     * @since JDK 1.6
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * reportId.
     *
     * @return the reportId
     * @since JDK 1.6
     */
    public Long getReportId() {
        return reportId;
    }

    /**
     * reportId.
     *
     * @param reportId the reportId to set
     * @since JDK 1.6
     */
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public Long getOfflineMoney() {
        return offlineMoney;
    }

    public void setOfflineMoney(Long offlineMoney) {
        this.offlineMoney = offlineMoney;
    }
    
    public Long getHzSettledMediaDivide() {
        return hzSettledMediaDivide;
    }

    
    public void setHzSettledMediaDivide(Long hzSettledMediaDivide) {
        this.hzSettledMediaDivide = hzSettledMediaDivide;
    }
    
    public Long getHegsSettledMediaDivide() {
        return hegsSettledMediaDivide;
    }

    public void setHegsSettledMediaDivide(Long hegsSettledMediaDivide) {
        this.hegsSettledMediaDivide = hegsSettledMediaDivide;
    }

    public String getBusinessRemark() {
        return businessRemark;
    }

    public void setBusinessRemark(String businessRemark) {
        this.businessRemark = businessRemark;
    }

    public Long getAdjustMoney() {
        return adjustMoney;
    }

    public void setAdjustMoney(Long adjustMoney) {
        this.adjustMoney = adjustMoney;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
