/**
 * Project Name:media-api File Name:RspMediaAppDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:23:36 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * ClassName:RspMediaAppDataStatisticsDto <br/>
 * Function: 媒体app Dto. <br/>
 * Date: 2016年10月13日 下午8:23:36 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspMediaAppDataStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -8689525577343654007L;

    /** 媒体ID. */
    private Long              appId;

    /** 媒体名称. */
    private String            appName;

    /** 媒体平台类型. */
    private String            platform;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击数. */
    private Long              clickCount;

    /** 点击率 */
    private Float             clickRate;

    /** 预计收入. */
    private Long              consumeTotal;

    /** 每一千次的有效价格. */
    private Long              eCpm;

    /** 点击单价. */
    private Long              cpc;

    /** 广告位成功响应数量 */
    private Long              actSucResponseCount;
    
    /**广告位访问pv*/
    private Long              slotRequestPv;
    
    /**广告位访问uv*/
    private Long              slotRequestUv;

    /*广告位有效访问PV*/
    private Long              slotEfRequestPvCount;

    /* ip访问量*/
    private Long              ipRequestPvCount;

    /*  新客访问量(UV)  */
    private Long              newRequestUvCount;

    /** 预计收入. */
    private Long              hzConsumeTotal;

    /** 预计收入. */
    private Long              hegsConsumeTotal;

    /**
     * 媒体cpc=预计收益/点击量
     */
    private Long              mediaCpc;
    /**
     * 媒体cpm=预计收益*1000/曝光量
     */
    private Long              mediaCpm;
    /**
     * 每UV收益=预计收益/广告位访问UV
     */
    private Long              mediaUvPrice;

    /**
     * geteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    public Long geteCpm() {
        return eCpm;
    }

    /**
     * seteCpm:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param eCpm
     * @since JDK 1.6
     */
    public void seteCpm(Long eCpm) {
        this.eCpm = eCpm;
    }

    public Long getCpc() {
        return cpc;
    }

    public void setCpc(Long cpc) {
        this.cpc = cpc;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.6
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.6
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Float getClickRate() {
        return clickRate;
    }

    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }
    
    public Long getSlotRequestPv() {
        return slotRequestPv;
    }

    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }
    
    public Long getSlotRequestUv() {
        return slotRequestUv;
    }
    
    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getSlotEfRequestPvCount() {
        return slotEfRequestPvCount;
    }

    public void setSlotEfRequestPvCount(Long slotEfRequestPvCount) {
        this.slotEfRequestPvCount = slotEfRequestPvCount;
    }

    public Long getIpRequestPvCount() {
        return ipRequestPvCount;
    }

    public void setIpRequestPvCount(Long ipRequestPvCount) {
        this.ipRequestPvCount = ipRequestPvCount;
    }

    public Long getNewRequestUvCount() {
        return newRequestUvCount;
    }

    public void setNewRequestUvCount(Long newRequestUvCount) {
        this.newRequestUvCount = newRequestUvCount;
    }


    public Long getMediaCpc() {
        return mediaCpc;
    }

    public void setMediaCpc(Long mediaCpc) {
        this.mediaCpc = mediaCpc;
    }

    public Long getMediaCpm() {
        return mediaCpm;
    }

    public void setMediaCpm(Long mediaCpm) {
        this.mediaCpm = mediaCpm;
    }

    public Long getMediaUvPrice() {
        return mediaUvPrice;
    }

    public void setMediaUvPrice(Long mediaUvPrice) {
        this.mediaUvPrice = mediaUvPrice;
    }

    /**
     * 排序
     *
     * @param param
     * @param mediaAppList
     * @return
     */
     public static  List<RspMediaAppDataStatisticsDto> listSort(ReqSlotLineStatisticsByPageDto param, List<RspMediaAppDataStatisticsDto> mediaAppList){ //NOSONAR
         String sort = param.getSort();
         String order = param.getOrder();
         if (Objects.nonNull(sort) && Objects.nonNull(order)) {
             formatList(sort,mediaAppList); //格式化
             switch (sort) {
                 case "exposureCount":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getExposureCount).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getExposureCount)).collect(Collectors.toList());
                     }
                 case "clickCount":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getClickCount).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getClickCount)).collect(Collectors.toList());
                     }
                 case "clickRate":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingDouble(RspMediaAppDataStatisticsDto::getClickRate).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingDouble(RspMediaAppDataStatisticsDto::getClickRate)).collect(Collectors.toList());
                     }
                 case "consumeTotal":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getConsumeTotal).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getConsumeTotal)).collect(Collectors.toList());
                     }
                 case "slotRequestPv":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getSlotRequestPv).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getSlotRequestPv)).collect(Collectors.toList());
                     }
                 case "slotRequestUv":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getSlotRequestUv).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getSlotRequestUv)).collect(Collectors.toList());
                     }
                 case "ipRequestPvCount":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getIpRequestPvCount).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getIpRequestPvCount)).collect(Collectors.toList());
                     }
                 case "newRequestUvCount":

                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getNewRequestUvCount).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getNewRequestUvCount)).collect(Collectors.toList());
                     }
                 case "mediaCpc":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaCpc).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaCpc)).collect(Collectors.toList());
                     }
                 case "mediaCpm":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaCpm).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaCpm)).collect(Collectors.toList());
                     }
                 case "mediaUvPrice":
                     if (Objects.equals(order, "desc")) {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaUvPrice).reversed()).collect(Collectors.toList());
                     } else {
                         return mediaAppList.stream().sorted(Comparator.comparingLong(RspMediaAppDataStatisticsDto::getMediaUvPrice)).collect(Collectors.toList());
                     }
                 default:
                     break;
             }
         }
         return mediaAppList;
    }

    /**
     * 格式化数据
     *
     * @param sort
     * @param mediaAppList
     */
    private static void formatList(String sort, List<RspMediaAppDataStatisticsDto> mediaAppList) { //NOSONAR
        switch (sort) {
            case "exposureCount":
                mediaAppList.stream().forEach(o -> o.setExposureCount(Objects.isNull(o.getExposureCount()) ? 0 : o.getExposureCount()));
                break;
            case "clickCount":
                mediaAppList.stream().forEach(o -> o.setClickCount(Objects.isNull(o.getClickCount()) ? 0 : o.getClickCount()));
                break;
            case "clickRate":
                mediaAppList.stream().forEach(o -> o.setClickRate(Objects.isNull(o.getClickRate()) ? 0 : o.getClickRate()));
                break;
            case "consumeTotal":
                mediaAppList.stream().forEach(o -> o.setConsumeTotal(Objects.isNull(o.getConsumeTotal()) ? 0 : o.getConsumeTotal()));
                break;
            case "slotRequestPv":
                mediaAppList.stream().forEach(o -> o.setSlotRequestPv(Objects.isNull(o.getSlotRequestPv()) ? 0 : o.getSlotRequestPv()));
                break;
            case "slotRequestUv":
                mediaAppList.stream().forEach(o -> o.setSlotRequestUv(Objects.isNull(o.getSlotRequestUv()) ? 0 : o.getSlotRequestUv()));
                break;
            case "ipRequestPvCount":
                mediaAppList.stream().forEach(o -> o.setIpRequestPvCount(Objects.isNull(o.getIpRequestPvCount()) ? 0 : o.getIpRequestPvCount()));
                break;
            case "newRequestUvCount":
                mediaAppList.stream().forEach(o -> o.setNewRequestUvCount(Objects.isNull(o.getNewRequestUvCount()) ? 0 : o.getNewRequestUvCount()));
                break;
            case "mediaCpc":
                mediaAppList.stream().forEach(o -> o.setMediaCpc(Objects.isNull(o.getMediaCpc()) ? 0 : o.getMediaCpc()));
                break;
            case "mediaCpm":
                mediaAppList.stream().forEach(o -> o.setMediaCpm(Objects.isNull(o.getMediaCpm()) ? 0 : o.getMediaCpm()));
                break;
            case "mediaUvPrice":
                mediaAppList.stream().forEach(o -> o.setMediaUvPrice(Objects.isNull(o.getMediaUvPrice()) ? 0 : o.getMediaUvPrice()));
                break;
            default:
                break;
        }

    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
