/**
 * Project Name:media-manager-biz File Name:ReqMaterialStatisticsBase.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2017年3月16日下午3:17:04 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqMaterialStatisticsBase <br/>
 * Function: 请求活动素材统计通用类. <br/>
 * Date: 2017年3月16日 下午3:17:04 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqMaterialStatisticsBase extends ReqPageQuery implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 9005271115032136403L;

    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    /** 活动素材ID */
    @ApiModelProperty(value = "活动素材ID", required = false)
    private Long              materialId;

    /** 活动ID */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              activityId;
    
    /** 广告位ID */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    /** 广告位规格ID */
    @ApiModelProperty(value = "广告位规格ID", required = false)
    private Long              msId;
    
    /**数据来源*/
    @ApiModelProperty(value = "数据来源", required = false)
    private Integer           source;
    
    @ApiModelProperty(value = "素材库ID", required = false)
    private Integer           sckId;

    

    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param startDate the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the materialId.
     *
     * @return the materialId
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * Sets the materialId.
     *
     * @param materialId the materialId
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * Gets the activityId.
     *
     * @return the activityId
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * Sets the activityId.
     *
     * @param materialId the activityId
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getSlotId() {
		return slotId;
	}

	public void setSlotId(Long slotId) {
		this.slotId = slotId;
	}

	/**
     * Gets the msId.
     *
     * @return the msId
     */
    public Long getMsId() {
        return msId;
    }

    /**
     * Sets the msId.
     *
     * @param msId the msId
     */
    public void setMsId(Long msId) {
        this.msId = msId;
    }
    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

	public Integer getSckId() {
		return sckId;
	}

	public void setSckId(Integer sckId) {
		this.sckId = sckId;
	}
}
