package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 关联媒体与管理员dto
 * 
 * @author songjiaxing
 *
 */
@ApiModel(description = "关联媒体与管理员DTO")
public class ReqMediaManagerCreateDto implements Serializable {

	private static final long serialVersionUID = 6068506401223694710L;

	// 媒体ID
	@ApiModelProperty(value = "媒体id", dataType = "Long")
	@NotNull
	private Long mediaId;

	// 管理员ID
	@ApiModelProperty(value = "管理员id", dataType = "List<Long>")
	private List<ReqManagerCreateDto> list;

	@ApiModelProperty(value = "客户类型", dataType = "Integer")
	private Integer clientType;

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public List<ReqManagerCreateDto> getList() {
		return list;
	}

	public void setList(List<ReqManagerCreateDto> list) {
		this.list = list;
	}

	public List<ReqManagerCreateDto> createManagerList() {
		list = new ArrayList<>();
		return list;
	}

	public Integer getClientType() {
		return clientType;
	}

	public void setClientType(Integer clientType) {
		this.clientType = clientType;
	}
}
