package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotRegionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotRegionImportRsp;

import java.util.List;

/**
    * @Descrption: 广告位地域类型操作接口
    * @author: miaohongshuai
    * @Date: 2019/4/10
*/
@AdvancedFeignClient
public interface RemoteSlotRegionService {

    /**
     * 根据广告位ID获取地域类型列表
     * @param slotId
     * @return
     */
    List<SlotRegionDto> selectBySlotId(Long slotId);

    /**
     * 新增地域类型
     * @param slotRegionDto
     * @return
     */
    Long saveRegion(SlotRegionDto slotRegionDto);

    /**
     * 更新地域类型
     * @param slotRegionDto
     * @return
     */
    int updateRegion(SlotRegionDto slotRegionDto);

    /**
     * 删除地域类型
     * @param regionId
     * @return
     */
    int deleteRegion(Long regionId);

    /**
     * 更新地域类型的生效状态，默认0:未生效，1：生效
     * @param regionId
     * @param slotId
     * @return
     */
    int updateRegionStatus(Long regionId, Long slotId);

    SlotRegionImportRsp importSlotRegion(List<String> cityNameList);
}
