/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位Dto <br/>
 * Date: 2016年9月26日 下午5:05:11 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class SlotDto extends BaseDto {

    /** 广告位类型 0-插屏. */
    public static final int    ADSENSE_TYPE_PLAQUE                        = 0;
    /** 广告位类型 1-横幅. */
    public static final int    ADSENSE_TYPE_STREAMER_BANNER               = 1;
    /** 广告位类型 2-信息流. */
    public static final int    ADSENSE_TYPE_INFORMATION_STREAM            = 2;
    /** 广告位类型 3-banner. */
    public static final int    ADSENSE_TYPE_BANNER                        = 3;
    /** 广告位类型 4-浮标. */
    public static final int    ADSENSE_TYPE_BUOY                          = 4;
    /** 广告位类型 5-应用墙. */
    public static final int    ADSENSE_TYPE_APP_WALL                      = 5;
    /** 广告位类型 6-开屏. */
    public static final int    ADSENSE_TYPE_OPEN_SCREEN                   = 6;
    /** 广告位类型 7-自定义. */
    public static final int    ADSENSE_TYPE_USER_DEFINED                  = 7;
    /** 广告位类型 8-手动投放. */
    public static final int    ADSENSE_TYPE_MANUAL                        = 8;
    /** 广告位类型 9-SDK投放. */
    public static final int    ADSENSE_TYPE_MATERIAL_SPEC                 = 9;
    /** 广告位类型 0-插屏. */
    public static final String ADSENSE_TYPE_PLAQUE_STR                    = "插屏";
    /** 广告位类型 1-横幅. */
    public static final String ADSENSE_TYPE_STREAMER_BANNER_STR           = "横幅";
    /** 广告位类型 2-信息流. */
    public static final String ADSENSE_TYPE_INFORMATION_STREAM_STR        = "信息流";
    /** 广告位类型 3-banner. */
    public static final String ADSENSE_TYPE_BANNER_STR                    = "banner";
    /** 广告位类型 4-浮标. */
    public static final String ADSENSE_TYPE_BUOY_STR                      = "浮标";
    /** 广告位类型 5-应用墙. */
    public static final String ADSENSE_TYPE_APP_WALL_STR                  = "应用墙";
    /** 广告位类型 6-开屏. */
    public static final String ADSENSE_TYPE_OPEN_SCREEN_STR               = "开屏";
    /** 广告位类型 7-自定义. */
    public static final String ADSENSE_TYPE_USER_DEFINED_STR              = "自定义";
    /** 广告位类型 8-手动投放. */
    public static final String ADSENSE_TYPE_MANUAL_STR                    = "手动投放";
    /** 广告位类型 9-SDK投放. */
    public static final String ADSENSE_TYPE_MATERIAL_SPEC_STR             = "SDK投放";
    /** 开通状态:0-待审核. */
    public static final int    CHECK_STATUS_CHECKING                      = 0;
    /** 开通状态:1-审核通过. */
    public static final int    CHECK_STATUS_PASS                          = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    CHECK_STATUS_FAIL                          = 2;
    /** 广告位状态:0-关闭. */
    public static final int    ENABLE_STATUS_CLOSE                        = 0;
    /** 广告位状态:1-开启. */
    public static final int    ENABLE_STATUS_OPEN                         = 1;
    /** 广告类型 -信息流-广告位尺寸 0-750*420. */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_SIZE_750_420 = 0;
    /** 广告类型 -信息流-广告位尺寸 1-750*180. */
    public static final int    ADSENSE_TYPE_INFORMATION_FLOW_TYPE_750_180 = 1;
    /** 75：42 广告尺寸. */
    public static final String FLOW_TYPE_SIZE_750_420                     = "750*420";
    /** 25：6 广告尺寸. */
    public static final String FLOW_TYPE_SIZE_750_180                     = "750*180";
    /** 类型数量. */
    public static final int    ADSENSE_TYPE_SIZE                          = 9;
    /** 已删除状态. */
    public static final int    IS_DELETE_STATUS                           = 1;
    /** 未删除状态. */
    public static final int    NO_DELETE_STATUS                           = 0;
    /** 轮询投放方式. */
    public static final int    POLLING_PUTWAY                             = 0;
    /** 定时投放方式. */
    public static final int    TIMING_PUTWAY                              = 1;

    /** 活动组-定时投放方式. */
    public static final int    GROUP_PUTWAY                               = 2;
    /** 活动组-比例投放方式. */
    public static final int    RATIO_PUTWAY                               = 3;

    /** 未冻结 */
    public static final int    NO_FROZEN_STATUS                           = 0;
    /** 已冻结 */
    public static final int    IS_FROZEN_STATUS                           = 1;

    /** 1 图片 */
    public static final int    SCK_PIC                                    = 1;
    /** 2 图文 */
    public static final int    SCK_PIC_CHAR                               = 2;
    /** 3 文字链 */
    public static final int    SCK_CHAR                                   = 3;

    /** gif 启用 */
    public static final int    GIF_ENABLE                                 = 1;
    /** gif关闭 */
    public static final int    GIF_CLOSE                                  = 0;

    /** 广告位显示广告类型 0-互动广告 */
    public static final int    SLOT_ACCESS_TYPE_HD                          = 0;

    /** 广告位显示广告类型 1-展示广告 */
    public static final int    SLOT_ACCESS_TYPE_ZS                          = 1;

    /** 客服按钮开启 */
    public static final int    SERVICE_STATUS_ENABLE                        = 1;

    /** 客服按钮关闭 */
    public static final int    SERVICE_STATUS_DISABLE                       = 0;

    /** 满足客服按钮关闭条件的流量分级标签的名字 **/
    public static final String CLOSE_GRADE_TAG_NAME_THREE_LEVEL = "三级流量";

    public static final String CLOSE_GRADE_TAG_NAME_OVERSEAS = "海外";

    private static final Long MEDIAID = -1l;

    private static final Long APPID = -1l;

    /** The Constant serialVersionUID. */
    private static final long  serialVersionUID                           = 8911023809144330642L;
    /** 媒体ID. */
    private Long               appId;

    /** 媒体用户ID. */
    private Long               mediaId;

    /** 广告位名称. */
    private String             slotName;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer            slotType;

    /** 素材规格ID. */
    private Long               slotMsId;

    /** 审核状态:0-待审核;1-审核拒绝;2-审核通过. */
    private Integer            checkStatus;

    /** 广告位状态:0-关闭;1-开启. */
    private Integer            enableStatus;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    private Integer            pictureSize;

    /** 屏蔽策略ID. */
    private Long               strategyId;

    /** 小图标是否可见. */
    private Boolean            isVisibleOfIco;

    /** 关闭按钮是否可见. */
    private Boolean            isVisibleOfCloseButton;

    /** 手动投放时的活动投放地址. */
    private String             activityUrl;

    /** 手动投放时的活动投放目标地址. */
    private String             activityTargetUrl;

    /** 广告位曝光上限. */
    private Integer            slotExposeLimit;

    /** 活动曝光上限. */
    private Integer            activityExposeLimit;

    /** 删除状态. */
    private Integer            deleteStatus;

    /** 是否拦截返回操作(1:拦截，0:不拦截). */
    private Boolean            isReturn;

    /** 拦截返回操作频次. */
    private Integer            numReturn;

    /** 每次拦截返回次数. */
    private Integer            timesReturn;

    /** 推荐位弹层开关(1:开，0:关). */
    private Boolean            isRecommend;

    /** 广告位投放方式 */
    private Integer            activityPutWay;

    /** 冻结状态 */
    private Integer            frozenStatus;

    /** 冻结原因 */
    private String             frozenReason;

    /** 管理端屏蔽策略标签 */
    private Long               managerStrategyId;

    /** 广告位添加备注 **/
    private String             remark;

    /** 广告位备注信息 **/
    private String             remarkImg;

    /** 活动客服开关(1:开，0:关). */
    private Integer            showService;

    /** 活动客服样式ID */
    private Long               showServiceId;

    /** 手动投放素材类型 */
    private Integer            sckType;

    /** gif开启状态 */
    private Integer            gifStatus;

    /** 自动填充 */
    private Integer            autoFill;

    /** 广告位浮标插件配置信息 */
    private PlugBuoyConfigDto  plugBuoyConfigDto;

    /** 激励开关(0-关闭，1-默认，2-自定义) */
    private Integer incentiveSwitch;

    /** 接入广告类型 0-互动广告 1-展示广告 */
    private Integer slotAccessType;

    /** 激励活动内容配置 */
    private IncentiveContentDto incentiveContentDto;

    /** 开启激励配置时是否返回拦截红包雨，1：是，0：否--不触发增值 */
    private Integer incentiveIntercept;

    /**
     * slotNumToName:(获取广告位类型名称通过广告类型编号). <br/>
     *
     * @param slotType the slot type
     * @return the slot type name by slot type
     * @since JDK 1.6
     */
    public static String getSlotTypeNameBySlotType(int slotType) {// NOSONAR
        String slotTypeName = "";
        switch (slotType) {
            case ADSENSE_TYPE_PLAQUE:
                slotTypeName = "插屏";
                break;
            case ADSENSE_TYPE_STREAMER_BANNER:
                slotTypeName = "横幅";
                break;
            case ADSENSE_TYPE_INFORMATION_STREAM:
                slotTypeName = "信息流";
                break;
            case ADSENSE_TYPE_BANNER:
                slotTypeName = "banner";
                break;
            case ADSENSE_TYPE_BUOY:
                slotTypeName = "浮标";
                break;
            case ADSENSE_TYPE_APP_WALL:
                slotTypeName = "应用墙";
                break;
            case ADSENSE_TYPE_OPEN_SCREEN:
                slotTypeName = "开屏";
                break;
            case ADSENSE_TYPE_USER_DEFINED:
                slotTypeName = "自定义";
                break;
            case ADSENSE_TYPE_MANUAL:
                slotTypeName = "手动投放";
                break;
            case ADSENSE_TYPE_MATERIAL_SPEC:
                slotTypeName = "SDK投放";
                break;
            default:
                break;
        }
        return slotTypeName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemarkImg() {
        return remarkImg;
    }

    public void setRemarkImg(String remarkImg) {
        this.remarkImg = remarkImg;
    }

    public Integer getFrozenStatus() {
        return frozenStatus;
    }

    public void setFrozenStatus(Integer frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public String getFrozenReason() {
        return frozenReason;
    }

    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    /**
     * Checks if is visible of ico.
     *
     * @return true, if checks if is visible of ico
     */
    public Boolean isVisibleOfIco() {
        return isVisibleOfIco;
    }

    /**
     * Sets the visible of ico.
     *
     * @param isVisibleOfIco the visible of ico
     */
    public void setVisibleOfIco(Boolean isVisibleOfIco) {
        this.isVisibleOfIco = isVisibleOfIco;
    }

    /**
     * Checks if is visible of close button.
     *
     * @return true, if checks if is visible of close button
     */
    public Boolean isVisibleOfCloseButton() {
        return isVisibleOfCloseButton;
    }

    /**
     * Sets the visible of close button.
     *
     * @param isVisibleOfCloseButton the visible of close button
     */
    public void setVisibleOfCloseButton(Boolean isVisibleOfCloseButton) {
        this.isVisibleOfCloseButton = isVisibleOfCloseButton;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the media id.
     *
     * @return the media id
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * Sets the media id.
     *
     * @param mediaId the media id
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * Gets the check status.
     *
     * @return the check status
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * Sets the check status.
     *
     * @param checkStatus the check status
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * Gets the slot type.
     *
     * @return the slot type
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * Sets the slot type.
     *
     * @param slotType the slot type
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * Gets the enable status.
     *
     * @return the enable status
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * Sets the enable status.
     *
     * @param enableStatus the enable status
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * Gets the picture size.
     *
     * @return the picture size
     */
    public Integer getPictureSize() {
        return pictureSize;
    }

    /**
     * Sets the picture size.
     *
     * @param pictureSize the picture size
     */
    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * Gets the strategy id.
     *
     * @return the strategy id
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * Sets the strategy id.
     *
     * @param strategyId the strategy id
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * Gets the activity url.
     *
     * @return the activity url
     */
    public String getActivityUrl() {
        return activityUrl;
    }

    /**
     * Sets the activity url.
     *
     * @param activityUrl the activity url
     */
    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    /**
     * Gets the activity target url.
     *
     * @return the activity target url
     */
    public String getActivityTargetUrl() {
        return activityTargetUrl;
    }

    /**
     * Sets the activity target url.
     *
     * @param activityTargetUrl the activity target url
     */
    public void setActivityTargetUrl(String activityTargetUrl) {
        this.activityTargetUrl = activityTargetUrl;
    }

    /**
     * Gets the slot expose limit.
     *
     * @return the slot expose limit
     */
    public Integer getSlotExposeLimit() {
        return slotExposeLimit;
    }

    /**
     * Sets the slot expose limit.
     *
     * @param slotExposeLimit the slot expose limit
     */
    public void setSlotExposeLimit(Integer slotExposeLimit) {
        this.slotExposeLimit = slotExposeLimit;
    }

    /**
     * Gets the activity expose limit.
     *
     * @return the activity expose limit
     */
    public Integer getActivityExposeLimit() {
        return activityExposeLimit;
    }

    /**
     * Sets the activity expose limit.
     *
     * @param activityExposeLimit the activity expose limit
     */
    public void setActivityExposeLimit(Integer activityExposeLimit) {
        this.activityExposeLimit = activityExposeLimit;
    }

    /**
     * Gets the delete status.
     *
     * @return the delete status
     */
    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    /**
     * Sets the delete status.
     *
     * @param deleteStatus the delete status
     */
    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    /**
     * Gets the slot ms id.
     *
     * @return the slot ms id
     */
    public Long getSlotMsId() {
        return slotMsId;
    }

    /**
     * Sets the slot ms id.
     *
     * @param slotMsId the slot ms id
     */
    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Boolean getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public Integer getNumReturn() {
        return numReturn;
    }

    public void setNumReturn(Integer numReturn) {
        this.numReturn = numReturn;
    }

    public Integer getTimesReturn() {
        return timesReturn;
    }

    public void setTimesReturn(Integer timesReturn) {
        this.timesReturn = timesReturn;
    }

    public Boolean getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getActivityPutWay() {
        return activityPutWay;
    }

    public void setActivityPutWay(Integer activityPutWay) {
        this.activityPutWay = activityPutWay;
    }

    public Long getManagerStrategyId() {
        return managerStrategyId;
    }

    public void setManagerStrategyId(Long managerStrategyId) {
        this.managerStrategyId = managerStrategyId;
    }

    public Integer getShowService() {
        return showService;
    }

    public void setShowService(Integer showService) {
        this.showService = showService;
    }

    public Long getShowServiceId() {
        return showServiceId;
    }

    public void setShowServiceId(Long showServiceId) {
        this.showServiceId = showServiceId;
    }

    public PlugBuoyConfigDto getPlugBuoyConfigDto() {
        return plugBuoyConfigDto;
    }

    public void setPlugBuoyConfigDto(PlugBuoyConfigDto plugBuoyConfigDto) {
        this.plugBuoyConfigDto = plugBuoyConfigDto;
    }

    public Integer getSckType() {
        return sckType;
    }

    public void setSckType(Integer sckType) {
        this.sckType = sckType;
    }

    public Integer getGifStatus() {
        return gifStatus;
    }

    public void setGifStatus(Integer gifStatus) {
        this.gifStatus = gifStatus;
    }

    public Integer getAutoFill() {
        return autoFill;
    }

    public void setAutoFill(Integer autoFill) {
        this.autoFill = autoFill;
    }

    public Integer getIncentiveSwitch() {
        return incentiveSwitch;
    }

    public void setIncentiveSwitch(Integer incentiveSwitch) {
        this.incentiveSwitch = incentiveSwitch;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    public IncentiveContentDto getIncentiveContentDto() {
        return incentiveContentDto;
    }

    public void setIncentiveContentDto(IncentiveContentDto incentiveContentDto) {
        this.incentiveContentDto = incentiveContentDto;
    }

    public Integer getIncentiveIntercept() {
        return incentiveIntercept;
    }

    public void setIncentiveIntercept(Integer incentiveIntercept) {
        this.incentiveIntercept = incentiveIntercept;
    }

    /**
     * 构造虚拟广告位
     * @param slotDto
     * @return
     */
    public static SlotDto buildVirtualSlot(SlotDto slotDto){
        slotDto.setMediaId(MEDIAID);
        slotDto.setAppId(APPID);
        slotDto.setSlotType(SlotDto.ADSENSE_TYPE_MANUAL);
        slotDto.setCheckStatus(0);
        slotDto.setEnableStatus(0);
        slotDto.setGifStatus(1);
        return slotDto;
    }

}
