package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Arrays;

public enum ModifyType {


    DEFAULT(-1,""),
    NEW_SDK(0,"新建sdk"),
    NEW_CONFIG(1,"新建配置方案"),
    UPDATE_CONFIG(2,"更新配置方案"),
    DELETE_CONFIG(3,"删除配置方案");

    private Integer code;

    private String desc;

    ModifyType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static String getDescByCode(Byte code) {
        return Arrays.asList(ModifyType.values()).stream()
                .filter(e -> e.getCode().intValue() == code.intValue())
                .findFirst()
                .orElse(DEFAULT)
                .getDesc();
    }
}
