package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPluginSetDTO;
import cn.com.duiba.tuia.ssp.center.api.params.SdkVerifyRecordParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteTuiaPluginSetService {

    List<TuiaSdkPluginSetDTO> listPluginSet(BaseQueryDto baseQueryDto);

    PageDto<TuiaSdkPluginSetDTO> listByPage(BaseQueryDto baseQueryDto);

    List<TuiaSdkPluginSetDTO> listAll();

    Boolean insert(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO);

    Boolean update(TuiaSdkPluginSetDTO tuiaSdkPluginSetDTO) throws BizException;

    Boolean deleteById(Long id);

    TuiaSdkPluginSetDTO getById(Long id);

    List<TuiaSdkPluginSetDTO> listByPluginId(Long pluginId);

    List<TuiaSdkPluginSetDTO> listByAppKey(String appKey);

    List<TuiaSdkPluginSetDTO> listByAppKeyAndSdkVersionCode(String appKey, Long sdkVersionCode);

    List<TuiaSdkPluginSetDTO> listBySdkVersionCode(Long versionCode);

    Boolean updateVerifyStatus(SdkVerifyRecordParam param);
}
