package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ip地址对应区域表
 */
public class IpAreaLibraryDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 起始值
     */
    private Long startIpNum;

    /**
     * 结束值
     */
    private Long endIpNum;

    /**
     * 中国
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区县
     */
    private String district;

    /**
     *
     */
    private String isp;

    /**
     * 行政编号
     */
    private Integer areaCode;

    /**
     * 工具方法，把字符串ip转换成数字，方便搜索
     *
     * @param strip 1.1.1.1
     * @return 16843009
     */
    public static Long convertIpLong(String strip) {
        try {
            long[] ip = new long[4];
            int position1 = strip.indexOf('.');
            int position2 = strip.indexOf('.', position1 + 1);
            int position3 = strip.indexOf('.', position2 + 1);
            ip[0] = Long.parseLong(strip.substring(0, position1));
            ip[1] = Long.parseLong(strip.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strip.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strip.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];//ip1*256*256*256+ip2*256*256+ip3*256+ip4
        } catch (Exception e) {
            return null;
        }
    }

    public void setStartIpNum(Long startIpNum) {
        this.startIpNum = startIpNum;
    }

    public Long getStartIpNum() {
        return startIpNum;
    }

    public void setEndIpNum(Long endIpNum) {
        this.endIpNum = endIpNum;
    }

    public Long getEndIpNum() {
        return endIpNum;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return country;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return city;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getDistrict() {
        return district;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getIsp() {
        return isp;
    }

    public void setAreaCode(Integer areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getAreaCode() {
        return areaCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
