/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppSlotHourStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月27日上午10:43:27<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName: ReqAppSlotHourStatistics <br/>
 * date: 2016年12月27日 上午10:43:27 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqAppSlotHourStatistics extends ReqStatHourlySort implements Serializable {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 3131692842635686910L;

    /** The app id. */
    @ApiModelProperty(value = "媒体ID", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long   appId;

    /** The slot id. */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long   slotId;

    /** 查询日期. */
    @ApiModelProperty(value = "查询日期", required = true)
    @NotNull(message = "查询日期不能为空")
    private String curDate;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String appName;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称(用作导出)", required = false)
    private String slotName;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the slot id.
     *
     * @return the slot id
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * Sets the slot id.
     *
     * @param slotId the slot id
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the cur date.
     *
     * @return the cur date
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * Sets the cur date.
     *
     * @param curDate the cur date
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
