/**
 * Project Name:ssp-center-api
 * File Name:ReqSlotFlowData.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年9月21日上午10:11:56
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqSlotFlowData <br/>
 * Function: 广告流量引导页 <br/>
 * Date:     2017年9月21日 上午10:11:56 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqSlotFlowStatDailyByPage extends BaseQueryDto{

    /**序列号*/
    private static final long serialVersionUID = 1709810164410576430L;
    
    /** 开始时间 */
    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String               startDate;

    /** 结束时间 */
    @ApiModelProperty(value = "结束时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String               endDate;
    
    /**广告位ID*/
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long slotId;
    
    /**流量引导页ID*/
    @ApiModelProperty(value = "流量引导页ID", required = false)
    private Long flowId;
    
    /**流量引导页名称*/
    @ApiModelProperty(value = "流量引导页名称", required = false)
    private String flowName;
    
    /** 导出方式. */
    @ApiModelProperty(value = "导出方式", required = false)
    private Integer     exportType; //0是汇总，1是分日导出
   

    
    public Integer getExportType() {
        return exportType;
    }


    
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }


    public String getStartDate() {
        return startDate;
    }

    
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    
    public String getEndDate() {
        return endDate;
    }

    
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    
    public Long getSlotId() {
        return slotId;
    }

    
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }
    
    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }
    
    public String getFlowName() {
        return flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

