package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AdvNewReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.AdvTagCreateDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqNewAdvCount;

import java.util.List;

/**
 * @author fangzhipeng
 * @date 2018/8/3
 */
@AdvancedFeignClient
public interface RemoteAdvNewReportService {

    /**
     * 保存新广告
     * 保存时只需传tagCode 和 advertisementId 即可
     * @param advNewReportDto 对应的数据库实体
     * @return 返回保存结果 true 成功 false 失败
     */
    boolean saveAdvNewReport(AdvNewReportDto advNewReportDto);


    /**
     * 检查该tag 下是否大于等于给定创建时间的广告
     * @param advTagCreateDtos 传入的 tagCode 和 gmtCreate
     * @return 改变传入对象里面的 haveAdv 字段来表示是否存在广告
     */
    List<AdvTagCreateDto> checkHaveAdv(List<AdvTagCreateDto> advTagCreateDtos);

    /**
     * 根据tag 获取 大于等于给定时间的 列表
     * 根据创建时间降序排列
     * @param advTagCreateDto 查询条件 封装 tagCode 和 gmtCreate
     * @return 对应的对象列表
     */
    List<AdvNewReportDto> getListByTagGECreate(AdvTagCreateDto advTagCreateDto);


    /**
     * 获取给定tagCodes 和 时间段内的 新增的广告数
     * 时间段包含上下界
     * @param req 请求参数
     * @return 返回对应的新增广告数
     */
    Integer getNewAdvCountByTagCodes(ReqNewAdvCount req);

    /**
     * 上报广告标签变更
     * @param advertId
     * @param oldTag
     * @param newTag
     * @return
     */
    boolean reportAdvertTagChange(Long advertId,String oldTag,String newTag);

    boolean reportAdvertDelete(List<Long> advertIds);

}
