/**
 * Project Name:ssp-center-api
 * File Name:RemoteMediaCashBillDataStoreService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年8月7日下午3:25:43
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqCashParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaCashBillDataStoreService <br/>
 * Function: 媒体提现账单数据存储(新增,修改). <br/>
 * Date:     2017年8月7日 下午3:25:43 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteMediaCashBillDataStoreService {
    
    /**
     * 
     * saveCashData:(保存提现数据). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> saveCashData(ReqCashParam param);
    
    /**
     * 
     * updateCashData:(修改提现数据). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> updateCashData(ReqCashParam param);

}

