package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Collection;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountRemitDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaCashOrderDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountRemitByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqCashDetail;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体提现单service
 * 
 *
 */
@AdvancedFeignClient
public interface RemoteMediaCashOrderService {

    /**
     *  根据id查询一条提现单记录
     * @param id
     * @return
     */
    public DubboResult<MediaCashOrderDto>    getOrderById(Long id);

    /**
     * 
     * getOrdersList:(查询提现明细列表). <br/>
     * 
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<MediaCashOrderDto>>   getCashOrdersList(ReqCashDetail param);
    
    /**
     * 
     * getCashOrdersCount:(查询提现明细). <br/>
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer>  getCashOrdersCount(ReqCashDetail param);

    /**
     * 修改提现状态，需修改cash_order表和account_report_month表状态
     * @param cashOrderId
     * @param status
     * @return
     */
    public DubboResult<Boolean>  updateCashStatus(Long cashOrderId,Integer status,String checkMsg);
    
    /**
     * 查询媒体提现订单通过月账单中的提现单IDs
     *
     * @param cashOrderIds
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<MediaCashOrderDto>> selectMediaCashOrderListByIds(Collection<Long> cashOrderIds);
    
    /**
     * 
     * 分页查询提现确认打款清单
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<AccountRemitDto>> selectAccountRemitList(ReqAccountRemitByPage param);
    
    /**
     * 查询提现确认打款清单数量
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> selectAccountRemitCount(ReqAccountRemitByPage param);
    /**
     * 
     * selectOrderIdsByStatus:(通过审核状态和提现单ids查询提现单ids). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @param checkStatus
     * @return
     */
    public DubboResult<List<Long>> selectOrderIdsByStatus(List<Long> cashOrderIds,Integer checkStatus);
    
    /**
     * updateCashRequirementStatus:更新请款状态. <br/>
     *
     * @author Administrator
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer> updateCashRequirementStatus(Long id);

    /**
     * 提现单审批
     *
     * @param mediaCashOrderDto
     * @param auditor
     * @return
     */
    DubboResult<Boolean>  updateCashOrderStatus(MediaCashOrderDto mediaCashOrderDto, String auditor);

    /**
     *  根据提现单查询一条提现单记录
     * @param cashOrderId
     * @return
     */
    DubboResult<MediaCashOrderDto> getOrderByCashOrderId(Long cashOrderId);

    /**
     * selectOrderIdsByStatusAndType:(通过审核状态和提现单ids查询提现单ids). <br/>
     *
     * @param cashOrderIds
     * @param checkStatus
     * @param companyType
     * @return
     * @author xuefneg
     */
    List<Long> selectOrderIdsByStatusAndType(List<Long> cashOrderIds, Integer checkStatus, Integer companyType);

    /**
     * 根据媒体id和提现状态来查询所有的提现单id
     * @param mediaId
     * @param check_status
     * @return
     */
    List<Long> queryMediaCashBillIds(Long mediaId,Integer check_status);
}
