package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotGameDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteSlotGameService {
    /**
     * 批量插入广告位定制游戏
     * @param slotGameDtos 广告位定制活动列表
     * @param slotId 必传广告位ID
     * @return
     */
    int save(List<SlotGameDto> slotGameDtos,Long slotId);

    /**
     *
     * @param slotId 广告位ID
     * @return 查询广告位定制的游戏
     */
    List<SlotGameDto> selectBySlotId(Long slotId);

    /**
     * 推广计划删除时检查
     * @param gameId　游戏id
     * @param gameSource　游戏来源
     * @return
     */
    List<SlotGameDto> selectByGameAndSouce(Long gameId, Integer gameSource);
}
