package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


public enum AgentSettlementTypeEnum {

    HZ_AGENT((byte)0, "杭推代理结算单"),
    HEGS_AGENT((byte)1, "霍推代理结算单"),
    HCDJ_AGENT((byte)2, "兑捷代理结算单");

    private Byte type;
    private String desc;

    AgentSettlementTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static final Map<Byte, String> AGENT_COMPANY_MAP;

    static {
        Map<Byte, String> temp = new HashMap<>(AgentSettlementTypeEnum.values().length, 1);
        for (AgentSettlementTypeEnum tag: AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), tag.getDesc());
        }
        AGENT_COMPANY_MAP = Collections.unmodifiableMap(temp);
    }

    public Byte getType() {
        return type;
    }

    public void setType(final Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(final String desc) {
        this.desc = desc;
    }

    public static String getCompanyName(Integer type) {
        for(AgentSettlementTypeEnum settlementType : AgentSettlementTypeEnum.values()) {
            if(settlementType.getType().equals(type)) {
                return settlementType.getDesc();
            }
        }
        return null;
    }
}