package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Objects;

/**
 * 注意：
 * 1.redis 前缀不要定义的太长
 * 2.系统前缀一定要加
 * 3.
 */
public class RedisKeyConstant {

	private static final String PREFIX = "TSW_";

	private static final String KEY_PREFIX="SSP_";
	
	/** 活动类型和活动类型中文KEY */
	private static final String ACT_AND_NAME_KEY = "K00_";
    
    /** 活动类型和活动类型中文KEY */
	private static final String ALL_ACT_AND_NAME_KEY = "K01_";
    
    /** 媒体应用的ID和名称集合标识. */
	private static final String APPID_AND_NAME_KEY   = "K02_";
	
	/** 广告位ID和广告位名称集合标示 */
	private static final String SOLTID_AND_NAME_KEY  = "K03_";
	
	/** 屏蔽策略标识. */
	private static final String STRATEGY_KEY = "K04_";
	
	/** 媒体标识. */
	private static final String MEDIA_APP_BY_KEY = "K05_";
	
	/** 广告位标识. */
	private static final String SLOT_KEY = "K06_";
	
	/** 活动定向媒体标识 --type*/
	private static final String ACTIVITY_DIRECT_APP_KEY = "K07_";
	
	/** 活动定向媒体标识--source */
	private static final String ACTIVITY_SOURCE_DIRECT_APP_KEY = "K08_";
	
	/** 媒体用户状态标识. */
	private static final String MEDIA_STATUS_KEY = "K09_";
	
	/** 媒体标识. */
	private static final String MEDIA_APP_KEY = "K10_";
	
	/** 媒体用户标识 */
	private static final String MEDIA_ACOUNT_KEY = "K11_";
	
	/** 修改邮件验证码标识. */
	private static final String REPLACE_EMAIL_KEY = "K13_";
	
	/** 找回密码邮件验证码标识. */
	private static final String RESETPD_EMAIL_KEY = "K14_";
	
	/** 短信缓存标识. */
	private static final String SMS_KEY = "K15_";
	
	/** 活动标识 */
	private static final String ACTIVITY_KEY = "K16_";
	
	/** 活动关联广告标识 */
	private static final String ACTIVITY_ADVERT_KEY  = "K17_";
	
	/** 活动关联广告标识 (根据活动来源)*/
	private static final String ACTIVITY_SOURCE_ADVERT_KEY  = "K18_";

    /**
     * 活动测试计划key
     */
    private static final String ACTIVITY_TEST_PLAN_INFO_KEY="K19_";

	/** 广告位屏蔽策略*/
	private static final String SLOT_SHIELD_STRATEGY_KEY = "SSP_CENTER_K19_";

    /** 活动定向广告位标识*/
    private static final String ACTIVITY_DIRECT_ADVERT_KEY = "SSP_CENTER_K20_";

    /** 标签库关联关系 **/
    private static final String TAG_RELATION_KEY = "SSP_CENTER_K21_";
    
    /** 活动表示 （根据来源）*/
    private static final String ACTIVITY_SOURCE_KEY  = "-ACTIVITY-SOURCE-";
    
    private static final String REWARDSTRATEGY_COPY_MONTH_KEY = "REWARDSTRATEGY-COPY-";

    private static final String ADMIN_GROUP_KEY="ADMIN_GROUP_KEY";

    /**
     * 风控预付款缓存key
     */
    private static final String PAY_PRE_RISK_MARK_KEY="PAY-PRE-RISK-MARK-KEY-";

    /**
     * 互通广告申请分发KEY
     */
    private static final String INTER_FLOW_APPLY_KEY="INTER_FLOW_APPLY_KEY_";
    /**
     * 暂存app KEY
     */
    private static final String TEMPORARY_APP_KEY="TEMPORARY_APP_KEY_";

    /**
     * 暂存广告位 KEY
     */
    private static final String TEMPORARY_SLOT_KEY="TEMPORARY_SLOT_KEY_";


    /**
     * 媒介变更消息通知 KEY
     */
    private static final String MEDIUM_MESSAGE_NOTICE_KEY="MEDIUM_MESSAGE_NOTICE_KEY_";


    /**
     * 媒介最新历史纪录 KEY
     */
    private static final String MEDIUM_MESSAGE_HISTORY_INFO_KEY="MEDIUM_MESSAGE_HISTORY_INFO_KEY_";

    /** 激活邮箱验证码redis key */
    private static final String ACTIVATE_EMAIL_KEY = "ACTIVATE_EMAIL_KEY_";
    
    private RedisKeyConstant(){

    }

    /**
     * 活动类型和活动类型中文KEY <br/>
     *
     * @param actType
     * @return
     */
    public static String getActTypeAndNameKey(String actType) {
        return PREFIX + ACT_AND_NAME_KEY + actType;
    }
    
    /**
     * 获取所有活动类型和活动类型中文KEY <br/>
     *
     * @return
     */
    public static String getAllActTypeAndNameKey() {
        return PREFIX + ALL_ACT_AND_NAME_KEY;
    }
    
    /**
     * 媒体应用的ID和名称集合标识.
     *
     * @param appId the app id
     * @return the app id and name key
     */
    public static String getAppIdAndNameKey(long appId) {
        return PREFIX + APPID_AND_NAME_KEY + appId;
    }
    
    /**
     * 广告位ID和广告位名称集合标示 <br/>
     *
     * @param slotId
     * @return
     */
    public static String getSlotIdAndNameKey(long slotId) {
        return PREFIX + SOLTID_AND_NAME_KEY + slotId;
    }
    
    /**
     * 获取屏蔽策略缓存标识.
     *
     * @param strategyId 屏蔽策略ID
     * @return the strategy key
     */
    public static String getStrategyKey(long strategyId) {
        return PREFIX + STRATEGY_KEY + strategyId;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param appKey app key
     * @return the media app key
     */
    public static String getMediaAppByKey(String appKey) {
        return PREFIX + MEDIA_APP_BY_KEY + appKey;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param slotId the slot id
     * @return the media app strategy key
     */
    public static String getSlotKey(long slotId) {
        return PREFIX + SLOT_KEY + slotId;
    }
    
    /**
     * 获取活动定向媒体的KEY
     * 
     * @param activityId
     * @param activityType
     * @return KEY
     */
    public static String getActivityDirectAppKey(Long activityId, Integer activityType) {
        return PREFIX + ACTIVITY_DIRECT_APP_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }
    
    /**
     * 获取活动(来源)定向媒体的KEY
     * 
     * @param activityId
     * @param source
     * @return KEY
     */
    public static String getActivityDirectAppKeyBySource(Long activityId, Integer source) {
        return PREFIX + ACTIVITY_SOURCE_DIRECT_APP_KEY + activityId + SplitConstant.SPLIT_HYPHEN + source;
    }
    
    /**
     * 获取媒体用户状态缓存标识.
     *
     * @param mediaId 媒体ID
     * @return the media status key
     */
    public static String getMediaStatusKey(long mediaId) {
        return PREFIX + MEDIA_STATUS_KEY + mediaId;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param mediaAppId 媒体ID
     * @return the media app key
     */
    public static String getMediaAppKey(long mediaAppId) {
        return PREFIX + MEDIA_APP_KEY + mediaAppId;
    }
    
    /**
     * getMediaAccountByKey:(通过key查询缓存中的媒体用户信息). <br/>
     *
     * @param mediaId
     * @return
     */
    public static String getMediaAccountByKey(Long mediaId) {
        return PREFIX + MEDIA_ACOUNT_KEY + mediaId;
    }
    
    /**
     * 获取更好邮箱的邮件验证码标识.
     *
     * @param userId the user id
     * @param token the token
     * @return the email key
     */
    public static String getReplaceEmailKey(Long userId, String token) {
        return PREFIX + REPLACE_EMAIL_KEY + userId + '-' + token;
    }
    
    /**
     * 获取邮件验证码标识.
     *
     * @param userEmail 邮箱
     * @return the email key
     */
    public static String getResetPwEmailKey(String userEmail) {
        return PREFIX + RESETPD_EMAIL_KEY + userEmail;
    }
    
    /**
     * 获取短信缓存标志.
     *
     * @param phone 手机号
     * @param type 类型
     * @return the sms key
     */
    public static String getSmsKey(String phone, int type) {
        return PREFIX + SMS_KEY + phone + "-" + type;
    }
    
    /**
     * 获取活动缓存标识.
     *
     * @param activityKey activity key
     * @return the activity key
     */
    public static String getActivityByKey(String activityKey) {
        return PREFIX + ACTIVITY_KEY + activityKey;
    }
    
    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param activityType
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKey(Long activityId, Integer activityType) {
        return PREFIX + ACTIVITY_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }
    
    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param source
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKeyAndSource(Long activityId, Integer source) {
        return PREFIX + ACTIVITY_SOURCE_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + source;
    }

    /**
     * 广告位屏蔽策略
     * @return
     */
    public static String getSlotShieldStrategyKey(){
        return SLOT_SHIELD_STRATEGY_KEY;
    }

    public static String getActivityDirectAdvertKey(){
        return  ACTIVITY_DIRECT_ADVERT_KEY;
    }

    public static String getTagRelationKey(){
        return  TAG_RELATION_KEY;
    }

    public static String getActivitySourceKey() {
        return ACTIVITY_SOURCE_KEY;
    }
    
    public static String getRewardStrategyCopyKey() {
        return REWARDSTRATEGY_COPY_MONTH_KEY;
    }

    public static String getAdminGroupKey() {
        return ADMIN_GROUP_KEY;
    }

    public static String getPayPreRiskMarkKey() {
        return PAY_PRE_RISK_MARK_KEY;
    }

    public static String getInterFlowOneValByKey(){
        return PREFIX + INTER_FLOW_APPLY_KEY;
    }

    public static String getTemporaryAppByKey(Long mediaId,Long appId){
        if (Objects.isNull(appId)){
            return PREFIX +APPID_AND_NAME_KEY+ TEMPORARY_APP_KEY+mediaId;
        }
        return PREFIX +APPID_AND_NAME_KEY+ TEMPORARY_APP_KEY+mediaId+SplitConstant.SPLIT_HYPHEN + appId;
    }

    public static String getTemporarySlotByKey(Long mediaId,Long slotId){
        if (Objects.isNull(slotId)){
            return PREFIX +SOLTID_AND_NAME_KEY+ TEMPORARY_SLOT_KEY+mediaId;
        }
        return PREFIX +SOLTID_AND_NAME_KEY+ TEMPORARY_SLOT_KEY+mediaId+SplitConstant.SPLIT_HYPHEN + slotId;
    }

    /**
     * 获取媒介变更消息通知KEY
     *
     * @param mediaId
     * @return
     */
    public static String getMediumMessageNoticeKey(Long mediaId){
        return PREFIX + MEDIUM_MESSAGE_NOTICE_KEY+mediaId;
    }

    /**
     * 获取媒介变更消息历史信息KEY
     *
     * @param mediaId
     * @return
     */
    public static String getMediumMessageHistoryInfoKey(Long mediaId){
        return PREFIX + MEDIUM_MESSAGE_HISTORY_INFO_KEY+mediaId;
    }

    /**
     * 大盘活动测试计划KEY
     *
     * @param activityId
     * @param slotId
     * @return
     */
    public static String getActivityTestPlanInfoKey(Long activityId,Long slotId,String curDate){
       return KEY_PREFIX + ACTIVITY_TEST_PLAN_INFO_KEY+activityId+SplitConstant.SPLIT_HYPHEN+slotId+SplitConstant.SPLIT_HYPHEN+curDate;
    }


    /*
     *获取邮箱激活验证码redis key
     *
     * @param email
     * @return
     */
    public static String getActivateEmailKey(String email) {
        return ACTIVATE_EMAIL_KEY + email;
    }
}

