/**
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.CommonConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ConfigHistoryVersionDto;

import java.util.List;

/**
 * 描述:公共配置
 *
 * @auther tangzhen@duiba.com.cn
 * @date 2019/7/04 13:58
 */
@AdvancedFeignClient
public interface RemoteCommonConfigService {

    /**
     * 根据环境查询
     *
     * @param
     * @return
     */
    List<CommonConfigDto> selectByEnv();

    CommonConfigDto selectByParamKey(String key);

    Integer addConfig(CommonConfigDto dto);

    Integer deleteConfigById(Long id);

    Integer updateConfigById(CommonConfigDto dto);

    /**
     * @Author zhangliwei
     * @Description  获取历史版本公共模块的配置详情
     * @Date 15:46 2019-08-16
     * @Param [param, version]
     * @return cn.com.duiba.tuia.media.manager.model.rsp.CommonConfigRsp
     **/
    CommonConfigDto getHistoryConfigDetail(String param, Integer version);


    /**
     * @Author zhangliwei
     * @Description  获取历史版本公共配置list
     * @Date 15:47 2019-08-16
     * @Param [param]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.HistoryVersionDto>
     **/
    List<ConfigHistoryVersionDto> getConfigHistoryList(String param);


    /**
     * @Author zhangliwei
     * @Description  公共模块配置回滚到指定版本
     * @Date 16:13 2019-08-16
     * @Param [param, version]
     * @return java.lang.Boolean
     **/
    Boolean rollBackConfig(String param, Integer version);

}
