/**
 * Project Name:media-api<br>
 * File Name:RspAccountBaseDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月8日下午1:39:02<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import cn.com.duiba.tuia.ssp.center.api.constant.SsoFieldShieldPathEnum;
import cn.com.duiba.tuia.ssp.center.api.tool.StringTool;
import com.google.common.collect.Lists;
import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;

/**
 * ClassName: RspAccountBaseDto <br/>
 * date: 2016年10月8日 下午1:39:02 <br/>
 *
 * @author xiawei
 * @since JDK 1.6
 */
@SensitiveInfo(sensitiveFields = {"email", "linkman", "linkmanPhone"})
public class RspAccountBaseDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 91777783199865422L;

    /**
     * 媒体账户ID.
     */
    private Long mediaId;

    /**
     * 邮箱.
     */
    @SensitiveInfo(sensitiveType = SensitiveType.EMAIL)
    private String email;

    /**
     * 邮箱状态:0：未验证;1：已验证.
     */
    private Integer emailStatus;

    /**
     * 公司名称.
     */
    private String companyName;

    /**
     * 营业执照号.
     */
    private String businessLicenseId;

    /**
     * 营业执照文件地址.
     */
    private String businessLicenseUrl;

    /**
     * 联系人姓名.
     */
    @SensitiveInfo(sensitiveType = SensitiveType.USERNAME)
    private String linkman;

    /**
     * 联系人手机号.
     */
    @SensitiveInfo(sensitiveType = SensitiveType.MOBILE)
    private String linkmanPhone;

    /**
     * 审核状态:0：审核中;1：审核通过;2：审核拒绝.
     */
    private Integer checkStatus;

    /**
     * 冻结状态:0-未冻结;1-已冻结.
     */
    private Integer freezeStatus;

    /**
     * 媒体账户当前余额
     */
    private Long balance;

    /**
     * 创建日期
     */
    private String createDate;

    /**
     * 账户类型：0-普通账户 1-线下打款账户
     */
    private Integer isOffline;

    /**
     * 管理员id
     */
    private List<Long> managerList;

    /**
     * 管理员名字
     */
    private List<String> managerNameList;

    /**
     * 用户类别
     */
    private Integer accountType;

    /**
     * 允许访问数据状态：0:关闭，1:开启
     */
    private Integer accessDataStatus;

    /**
     * 数据显示开始时间
     */
    private String startDate;

    /**
     * 数据显示关闭时间
     */
    private String endDate;

    /**
     * 代理商ID
     */
    private Long parentMediaId;

    /**
     * 是否是预付款账号类型
     */
    private Integer prePayStatus;

    /**
     * 预付款金额
     */
    private Long prePayAmount;

    /**
     * 杭州预付款金额
     */
    private Long hzPrePayAmount;

    /**
     * 霍尔果斯预付款金额
     */
    private Long hegsPrePayAmount;

    /**
     * 霍城兑捷预付款余额
     */
    private Long hcdjPrePayAmount;

    /**
     * 杭州当前余额 (分).
     */
    private Long hzBalance;

    /**
     * 霍尔果斯当前余额 (分).
     */
    private Long hegsBalance;
    /**
     * 霍城兑捷当前余额 (分).
     */
    private Long hcdjBalance;

    /**
     * 是否给与奖励 0否1是
     */
    private Integer hasReward;

    /**
     * 开启标志（0：关闭，1:开启）
     */
    private Integer openStatus;

    /**
     * 客户类型
     */
    private Integer clientType;

    /**
     * 是否支持展示广告 0--不支持  1--支持
     */
    private Integer supportDisplayAd;
    /**
     * 媒介负责人的名字
     */
    private String mediumManagerName;
    /**
     * 媒体负责人的名字
     */

    private List<String> operationManagerNameList;


    /**
     * 签署状态
     */
    private Byte contractStatus;

    /**
     * 已经签署的主体
     */
    private String companyType;

    public static final Integer CRM_FLAG_EXIST = 1;

    public static final Integer CRM_FLAG_NOT_EXIST = 0;
    /**
     * 是否已经同步到 crm的标识 (0:未同步 1:已同步)
     **/
    private Integer crmFlag;

    public Integer getCrmFlag() {
        return crmFlag;
    }

    public void setCrmFlag(Integer crmFlag) {
        this.crmFlag = crmFlag;
    }

    public Byte getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(final Byte contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public List<String> getOperationManagerNameList() {
        return operationManagerNameList;
    }

    public void setOperationManagerNameList(List<String> operationManagerNameList) {
        this.operationManagerNameList = operationManagerNameList;
    }

    public String getMediumManagerName() {
        return mediumManagerName;
    }

    public void setMediumManagerName(String mediumManagerName) {
        this.mediumManagerName = mediumManagerName;
    }

    public static String getEmailStatusStr(Integer status) {
        return getEmailStatusString(status);
    }

    private static String getEmailStatusString(Integer emailStatus) {
        if (emailStatus == null) {
            return "";
        }
        if (emailStatus == 0) {
            return "未验证";
        } else if (emailStatus == 1) {
            return "已验证";
        }
        return "";
    }

    public static String getFreezeStatusStr(Integer status) {
        return getFreezeStatusString(status);
    }

    private static String getFreezeStatusString(Integer freezeStatus) {
        if (freezeStatus == null) {
            return "";
        }
        if (freezeStatus == 0) {
            return "未冻结";
        } else if (freezeStatus == 1) {
            return "已冻结";
        }
        return "";
    }

    public static String getAccountTypeStr(Integer status) {
        return getAccountTypeString(status);
    }

    public static String getAccountTypeString(Integer accountType) {
        if (accountType == null) {
            return "";
        }
        if (accountType == 1) {
            return "直客";
        } else if (accountType == 2) {
            return "代理商";
        } else if (accountType == 3) {
            return "子账户";
        }
        return "";
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * freezeStatus.
     *
     * @return the freezeStatus
     * @since JDK 1.6
     */
    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    /**
     * freezeStatus.
     *
     * @param freezeStatus the freezeStatus to set
     * @since JDK 1.6
     */
    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.6
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.6
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * emailStatus.
     *
     * @return the emailStatus
     * @since JDK 1.6
     */
    public Integer getEmailStatus() {
        return emailStatus;
    }

    /**
     * emailStatus.
     *
     * @param emailStatus the emailStatus to set
     * @since JDK 1.6
     */
    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.6
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.6
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * businessLicenseId.
     *
     * @return the businessLicenseId
     * @since JDK 1.6
     */
    public String getBusinessLicenseId() {
        return businessLicenseId;
    }

    /**
     * businessLicenseId.
     *
     * @param businessLicenseId the businessLicenseId to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseId(String businessLicenseId) {
        this.businessLicenseId = businessLicenseId;
    }

    /**
     * businessLicenseUrl.
     *
     * @return the businessLicenseUrl
     * @since JDK 1.6
     */
    public String getBusinessLicenseUrl() {
        return businessLicenseUrl;
    }

    /**
     * businessLicenseUrl.
     *
     * @param businessLicenseUrl the businessLicenseUrl to set
     * @since JDK 1.6
     */
    public void setBusinessLicenseUrl(String businessLicenseUrl) {
        this.businessLicenseUrl = businessLicenseUrl;
    }

    /**
     * linkman.
     *
     * @return the linkman
     * @since JDK 1.6
     */
    public String getLinkman() {
        return linkman;
    }

    /**
     * linkman.
     *
     * @param linkman the linkman to set
     * @since JDK 1.6
     */
    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    /**
     * linkmanPhone.
     *
     * @return the linkmanPhone
     * @since JDK 1.6
     */
    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    /**
     * linkmanPhone.
     *
     * @param linkmanPhone the linkmanPhone to set
     * @since JDK 1.6
     */
    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * balance.
     *
     * @return the balance
     * @since JDK 1.6
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * balance.
     *
     * @param balance the balance to set
     * @since JDK 1.6
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    /**
     * createDate.
     *
     * @return the createDate
     * @since JDK 1.6
     */
    public String getCreateDate() {
        return createDate;
    }

    /**
     * createDate.
     *
     * @param createDate the createDate to set
     * @since JDK 1.6
     */
    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public List<Long> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<Long> managerList) {
        this.managerList = managerList;
    }

    public List<String> getManagerNameList() {
        return managerNameList;
    }

    public void setManagerNameList(List<String> managerNameList) {
        this.managerNameList = managerNameList;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccessDataStatus() {
        return accessDataStatus;
    }

    public void setAccessDataStatus(Integer accessDataStatus) {
        this.accessDataStatus = accessDataStatus;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Long getParentMediaId() {
        return parentMediaId;
    }

    public void setParentMediaId(Long parentMediaId) {
        this.parentMediaId = parentMediaId;
    }

    public String getEmailStatusDesc() {
        return getEmailStatusString(this.getEmailStatus());
    }

    public String getFreezeStatusDesc() {
        return getFreezeStatusString(this.getFreezeStatus());
    }

    public String getAccountTypeDesc() {
        return getAccountTypeString(this.getAccountType());
    }

    public Integer getPrePayStatus() {
        return prePayStatus;
    }

    public void setPrePayStatus(Integer prePayStatus) {
        this.prePayStatus = prePayStatus;
    }

    public Long getPrePayAmount() {
        return prePayAmount;
    }

    public void setPrePayAmount(Long prePayAmount) {
        this.prePayAmount = prePayAmount;
    }

    public Long getHzPrePayAmount() {
        return hzPrePayAmount;
    }


    public void setHzPrePayAmount(Long hzPrePayAmount) {
        this.hzPrePayAmount = hzPrePayAmount;
    }


    public Long getHegsPrePayAmount() {
        return hegsPrePayAmount;
    }

    public void setHegsPrePayAmount(Long hegsPrePayAmount) {
        this.hegsPrePayAmount = hegsPrePayAmount;
    }

    public Long getHzBalance() {
        return hzBalance;
    }


    public void setHzBalance(Long hzBalance) {
        this.hzBalance = hzBalance;
    }


    public Long getHegsBalance() {
        return hegsBalance;
    }


    public void setHegsBalance(Long hegsBalance) {
        this.hegsBalance = hegsBalance;
    }


    public Integer getHasReward() {
        return hasReward;
    }

    public void setHasReward(Integer hasReward) {
        this.hasReward = hasReward;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }

    public Integer getSupportDisplayAd() {
        return supportDisplayAd;
    }

    public void setSupportDisplayAd(Integer supportDisplayAd) {
        this.supportDisplayAd = supportDisplayAd;
    }

    public Long getHcdjPrePayAmount() {
        return hcdjPrePayAmount;
    }

    public void setHcdjPrePayAmount(Long hcdjPrePayAmount) {
        this.hcdjPrePayAmount = hcdjPrePayAmount;
    }

    public Long getHcdjBalance() {
        return hcdjBalance;
    }

    public void setHcdjBalance(Long hcdjBalance) {
        this.hcdjBalance = hcdjBalance;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    /**
     * 账户数据
     * @param path
     * @return
     */
    public List<String> installHidFileds(String path) {
        if (Objects.isNull(path)) {
            return Lists.newArrayList();
        }
        String dest=null;
        List<String> destList=Lists.newArrayList();
        // 媒体数据
        //注册邮箱 联系人 手机号码
        if (Objects.equals(path, SsoFieldShieldPathEnum.PATH_TYPE_MEDIA_DATA.getPath())) {
            dest= StringTool.join("email", "linkman", "linkmanPhone");
        }

        if (Objects.nonNull(dest)){
            return StringTool.getStringListByStr(dest);
        }
        return destList;
    }


}
