package cn.com.duiba.tuia.ssp.center.api.dto.slotActivityWayGroup;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class ReqActGroupFlowStatus {

    @ApiModelProperty(value = "广告位id", required = true)
    @NotNull(message = "广告位id不能为空")
    private Long slotId;

    @ApiModelProperty(value = "0为默认地域", required = true)
    @NotNull(message = "地域id不能为空")
    private Integer regionId;

    @ApiModelProperty(value = "0,1,2,3", required = true)
    @NotNull(message = "投放方式不能为空")
    private Byte activityPutWay;

    @ApiModelProperty(value = "保存状态 0-关闭", required = true)
    @NotNull(message = "保存状态不能为空")
    private Byte actGroupFlowStatus;

    // 活动组分流分配开关：关闭
    public static final int CLOSE_GROUP_FLOW = 0;
    // 活动组分流分配开关：打开
    public static final int OPEN_GROUP_FLOW = 1;
}
