package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityManualPlanDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 手动投放活动前台service
 */
@AdvancedFeignClient
public interface RemoteActivityManualService{

    /**
     * @param slotId
     * @return
     */
    DubboResult<ActivityManualPlanDto> findActivityManualPlan(Long slotId);
    
    /**
     * 
     * updateActivityManualPlanStatus:(修改手动投放状态 投放中->投放完成). <br/>
     *
     * @author guyan
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateActivityManualPlanStatus(Long id,Integer status);

    /**
     * 根据广告位ID和地域类型ID获取投放中的定时活动
     * @param slotId
     * @param regionId
     * @return
     */
    ActivityManualPlanDto findActivityManualPlanByRegion(Long slotId, Long regionId);

    ActivityManualPlanDto findActivityManualPlanByRegionV1(Long slotId, Long regionId,
            Byte belongToGroup);
}
