/**
 * Project Name:media-manager-biz File Name:ReqAppDayBillByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2017年2月8日下午2:12:17 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqAppDayBillByPage <br/>
 * Function: 媒体日账单. <br/>
 * Date: 2017年2月8日 下午2:12:17 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqAppDayBillByPage extends ReqPageQuery implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 5686406275611964214L;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", required = false)
    private String            email;

    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    /** 媒体IDS */
    @ApiModelProperty(value = "媒体IDS", required = false)
    private List<Long>        appIds;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              mediaId;
    
    /**账户类别*/
    @ApiModelProperty(value = "账户类别", required = false)
    private Integer           accountType;
    
    /**媒体用户ids*/
    @ApiModelProperty(value = "媒体用户ids", required = false)
    private List<Long> mediaIds;


    /** 广告IDS */
    @ApiModelProperty(value = "广告IDS", required = false)
    private List<Long> slotIds;

    /**
     * Gets the appIds.
     *
     * @return the appIds
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * Sets the appName.
     *
     * @param appName the appName
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(final List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    /**
     * Gets the appName.
     *
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the appName.
     *
     * @param appName the appName
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the appId.
     *
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the appId.
     *
     * @param appId the appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param email the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * Gets the mediaId.
     *
     * @return the mediaId
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * Sets the mediaId.
     *
     * @param mediaId the mediaId
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }
    
    /**
     * Gets the accountType.
     *
     * @return the accountType
     */
    public Integer getAccountType() {
        return accountType;
    }

    /**
     * Sets the accountType.
     *
     * @param accountType the accountType
     */
    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }
    
    /**
     * Gets the mediaIds.
     *
     * @return the mediaIds
     */
    public List<Long> getMediaIds() {
        return mediaIds;
    }

    /**
     * Sets the mediaIds.
     *
     * @param mediaIds the mediaIds
     */
    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
