/**
 * Project Name:ssp-center-api
 * File Name:RspAccountAmount.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年5月4日下午3:43:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName:RspAccountAmount <br/>
 * Function: 账户余额信息. <br/>
 * Date:     2017年5月4日 下午3:43:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class RspAccountAmount implements Serializable{

    /**序列号*/
    private static final long serialVersionUID = 1081041619680834753L;
    
    /**账户余额*/
    private Long amount;

    /**杭州账户余额*/
    private Long hzAmount;

    /**霍尔果斯账户余额*/
    private Long hegsAmount;

    /**霍城兑捷账户余额*/
    private Long hcdjAmount;
    
    /**审核状态*/
    private Integer checkStatus;

    /**
     * 杭州账单确认状态：0-未完成确认 1-已完成确认
     */
    private Integer hzVerifyStatus;

    /**
     * 霍尔果斯账单确认状态：0-未完成确认 1-已完成确认
     */
    private Integer hegsVerifyStatus;

    /**
     * 霍城兑捷账单确认状态：0-未完成确认 1-已完成确认
     */
    private Integer hcdjVerifyStatus;


    public Integer getHzVerifyStatus() {
        return hzVerifyStatus;
    }

    public void setHzVerifyStatus(Integer hzVerifyStatus) {
        this.hzVerifyStatus = hzVerifyStatus;
    }

    public Integer getHegsVerifyStatus() {
        return hegsVerifyStatus;
    }

    public void setHegsVerifyStatus(Integer hegsVerifyStatus) {
        this.hegsVerifyStatus = hegsVerifyStatus;
    }

    public Long getAmount() {
        return amount;
    }

    
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getHzAmount() {
        return hzAmount;
    }

    public void setHzAmount(Long hzAmount) {
        this.hzAmount = hzAmount;
    }

    public Long getHegsAmount() {
        return hegsAmount;
    }

    public void setHegsAmount(Long hegsAmount) {
        this.hegsAmount = hegsAmount;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Long getHcdjAmount() {
        return hcdjAmount;
    }

    public void setHcdjAmount(final Long hcdjAmount) {
        this.hcdjAmount = hcdjAmount;
    }

    public Integer getHcdjVerifyStatus() {
        return hcdjVerifyStatus;
    }

    public void setHcdjVerifyStatus(final Integer hcdjVerifyStatus) {
        this.hcdjVerifyStatus = hcdjVerifyStatus;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}

