package cn.com.duiba.tuia.ssp.center.api.constant;

public enum FlowType {
    ANDROID("安卓",2),
    IOS("IOS",1),
    OTHERS("其他",0);

    private String desc;

    private Integer code;

    FlowType(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }


    public static String getDescByCode(Integer code){
        for (FlowType temp: FlowType.values()){
            if (code.equals(temp.getCode())){
               return temp.getDesc();
            }
        }
        return "未知";
    }
}
