package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Optional;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/8 13:35
 * @Description:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class NewMediaBlackListDto extends NewMediaBlackList {


    /**
     * 媒体标签
     */
    private String appTag;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 账号名称
     **/
    private String mediaName;


    public NewMediaBlackListDto(NewMediaBlackList item, String appName, String appTag,String mediaName) {
        setId(item.getId());
        setAppId(item.getAppId());
        setIdType(item.getIdType());
        setGmtCreate(item.getGmtCreate());
        setGmtModified(item.getGmtModified());
        this.appName = Optional.ofNullable(appName).orElse("");
        this.appTag = Optional.ofNullable(appTag).orElse("");
        this.mediaName = Optional.ofNullable(mediaName).orElse("");
    }



}
