package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.constant.NewMediaTestEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/8 11:24
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteNewMediaTestService {

    /**
     * 分页查询新媒体列表
     * @param req
     * @return
     */
    PageResultDto<NewMediaTestDto> pageList(ReqPageQuery req);

    /**
     * 参加或不参加测试
     * @param id
     * @param appMark
     * @return
     */
    int markApp(Long id, ReqMarkAppDto appMark);

    /**
     * 修改测试状态
     * @param appIds
     * @param statusEnum
     * @return
     */
    int modifyStatus(List<Long> appIds, NewMediaTestEnum.StatusEnum statusEnum);


    /**
     * 查询所有的在测试中的媒体
     * @return
     */
    List<NewMediaTestDto> getAllTestingMedia();


    int insert(List<Long> appIds);


    /**
     * @Author zhangliwei
     * @Description  更新优先级方法
     * @Date 16:53 2019-09-11
     * @Param [id, type]
     * @return int
     **/
    int updatePriority(Long appId, Integer priority);

    /**
     * @Author zhangliwei
     * @Description  添加黑名单
     * @Date 15:53 2019-09-11
     * @Param [req]
     * @return int
     **/
    int addBlackList(List<Long> ids,Integer type);

    /**
     * @Author zhangliwei
     * @Description  移出黑名单
     * @Date 16:24 2019-09-11
     * @Param [id, type]
     * @return int
     **/
    int removeBlackList(Long id, Integer type);

    /**
     * @Author zhangliwei
     * @Description  分页查询黑名单列表
     * @Date 16:16 2019-09-11
     * @Param [req]
     * @return cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto<cn.com.duiba.tuia.ssp.center.api.dto.NewMediaTestDto>
     **/
    PageResultDto<NewMediaBlackListDto> getBlackListPageList(ReqPageQuery req);

    /**
     * @Author zhangliwei
     * @Description  同步回流表数据定时任务
     * @Date 15:16 2019-09-12
     * @Param []
     * @return boolean
     **/
    boolean  synchronizeBackFlow();
}
