package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.AdvertInSlotsShieldStatusDto;
import cn.com.duiba.tuia.ssp.center.api.params.advertselect.AdvertInSlotsShieldStatusQuery;
import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.advert.*;

import java.util.List;
import java.util.Set;

/**
 * @Author zhangliwei
 * @Description  互选广告初始化数据方法
 * @Date 17:04 2019-08-05
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteAdvertSelectInitService {

    /**
     * @Author zhangliwei
     * @Description  清理线上脏数据
     * @Date 17:05 2019-08-05
     * @Param []
     * @return boolean
     **/
    boolean clearData();

    /**
     * @Author zhangliwei
     * @Description  清理线上脏数据强化版
     * @Date 15:37 2019-08-26
     * @Param []
     * @return boolean
     **/
    @SuppressWarnings("squid:S3776")
    boolean clearDataV2();

    /**
     * @return boolean
     * @Author zhangliwei
     * @Description 将广告端应该同步过来但是未同步过来的广告/素材数据同步过来
     * @Date 18:22 2019-10-24
     * @Param []
     **/
    boolean initSyncAdvertData(Long mediaId);
}