package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMaterialService {

    DubboResult<Long> insert(MaterialDto record);

    DubboResult<Boolean> update(MaterialDto record);

    DubboResult<Boolean> delete(Long id);

    DubboResult<List<MaterialDto>> listByPage(ReqMaterialDto param);

    DubboResult<List<Long>> listIdByParam(String group, String type);

    DubboResult<Integer> countByParam(ReqMaterialDto param);

    DubboResult<List<MaterialToActDto>> list4Act(Long id, String title, String group, String type, Long msId);

    List<MaterialToActDto> newList4Act(Long id, String title, String group, String type, Long msId,String designer);

    DubboResult<List<MaterialDto>> listByMd5(MaterialDto record);

    DubboResult<MaterialDto> selectById(Long id);

    List<Long> saveBatchMaterial(List<ReqMaterialDto> list);

    boolean submitAudit(Long managerId,Long materialId);

    List<MaterialForSlot> getListForSlot(Long slotId);

    boolean materialChange();

    List<Long> saveBatchMaterialConfig(List<ReqMaterialConfigDto> list);

    boolean transferMaterialGroupToTag();

    boolean updateMaterialTag(List<String> tagIdStringList, Long materialId);

    List<MaterialToActDto> newList4ActByReqMaterialDto(ReqMaterialDto reqMaterialDto);

    /**
     * 更新素材库（只更新素材库这一张表，即tb_material，慎用）
     *
     * @param id
     * @param pictureSize
     * @return
     */
    Boolean initPictureSize(Long id, Long pictureSize);

    /**
     * 查询出所有没有大小的素材（初始化素材大小时使用）
     *
     * @return
     */
    List<MaterialDto> queryMaterialNoSize();

    boolean updateMaterialTitleAndDesc(List<MaterialDto> materialDtos);

    /**
     * 获取裁切素材列表
     *
     * @param param 查询条件
     * @return 裁切素材列表
     */
    List<MaterialCutDto> listMaterialCut(ReqMaterialCutDto param);

    /**
     * 获取裁切素材总数
     *
     * @param param 查询条件
     * @return 裁切素材总数
     */
    Integer countMaterialCut(ReqMaterialCutDto param);

    /**
     * 批量保存裁切素材
     *
     * @param records 裁切素材列表
     * @param fillStatus 是否填充数据，1：是，0：否
     * @param managerId 审核员id
     * @return 新增素材id
     */
    boolean saveBatchMaterialCut(List<ReqMaterialCutStyleDto> records, Integer fillStatus, Long managerId);

    /**
     * 获取裁切目标尺寸列表
     * @return 裁切目标尺寸列表
     */
    List<MaterialCutSpecificationDto> listMaterialCutSpecification();
}
