package cn.com.duiba.tuia.ssp.center.api.remote.monthreport;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.monthreport.MonthReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.monthreport.ReqMonthReportPageDto;

/**
 * 媒体月报远程接口
 * @author fangzhipeng
 * @date 2018/9/13
 */
@AdvancedFeignClient
public interface RemoteMonthReportService {

    /**
     * 获取分页月报列表
     *
     * gmtCreate desc
     * @param req 请求参数
     * @return
     */
    PageResultDto<MonthReportDto> pageList(ReqMonthReportPageDto req);

    /**
     * 保存 月报模型
     * @param dto 数据库实体
     * @return
     */
    int save(MonthReportDto dto);


    /**
     * 编辑媒体月报
     * @param dto
     * @return
     */
    int edit(MonthReportDto dto);

    /**
     * 获取媒体月报详情
     * @param id
     * @return
     */
    MonthReportDto detail(Long id);

    /**
     * 删除媒体月报
     * @param id
     * @return
     */
    int delete(Long id);



    /**
     * 发送媒体月报
     *
     * @param id
     */
    void send(Long id, String sender);

}
