package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: MediaCashOrderDto <br/>
 * Function: 提现单. <br/>
 * date: 2017年5月5日 上午11:27:57 <br/>
 *
 * @version
 * @since JDK 1.6
 */
public class MediaCashOrderDto extends BaseDto {

    //TODO 后续只用1，2，3，4，5，6
    /** 序列号 */
    private static final long      serialVersionUID = 8895863425584026044L;
    
    /**未提现*/
    public static final int  ORDER_CHECK_STATUS_NO=0;
    
    /**审核中 待媒介负责人审核*/
    public  static final int ORDER_CHECK_STATUS_AUDIT=1;
    
    /**提现拒绝 审核拒绝*/
    public  static final int ORDER_CHECK_STATUS_REFUSE=2;
    
    /**提现通过 待打款*/
    public  static final int ORDER_CHECK_STATUS_PASS=3;
    
    /**已打款*/
    public  static final int ORDER_CHECK_STATUS_PLAYED=4;

    /**待请款*/
    public  static final int ORDER_CHECK_STATUS_REQUIRES_CASH=5;

    /**待财务审核*/
    public  static final int ORDER_CHECK_STATUS_FINANCE_AUDIT=6;

    /**待总裁审核*/
    public  static final int ORDER_CHECK_STATUS_CEO_AUDIT=7;

    /**流量负责人审核*/
    public  static final int ORDER_CHECK_STATUS_FLOW_AUDIT=8;

    /**提现金额*/
    public  static final Long CASH_AMOUNT=1000000000L;
    
    
    
    /** 用户ID */
    private Long                   mediaId;

    /** 提现单号 */
    private Long                   cashOrderId;

    /** 联系人 */
    private String                 linkman;

    /** 联系人方式 */
    private String                 linkmanPhone;

    /** 邮寄地址 */
    private String                 senderAddr;

    /** 发票数量 */
    private Integer                billCount;

    /** 审核状态 */
    private Integer                checkStatus;

    /**拒绝原因类型0-其它1-合同问题2-发票问题**/
    private Integer                refuseType;

    /** 审核信息 */
    private String                 checkMsg;

    /** 邮寄类型 */
    private Integer                sendType;

    /** 所填发票金额 */
    private Long                fillInAmount;

    /** 发票信息 */
    private List<MediaCashBillDto> mediaCashBillDtos;

    /** 需要回寄结算单:0-不需要回寄结算单，1-需要回寄结算单 */
    private Integer                needBackSettlement;

    /** 银行名称 */
    private String                 bankName;

    /** 支行名称 */
    private String                 branchName;

    /** 公司名称 */
    private String                 financeCompanyName;

    /** 银行卡号 */
    private String                 cardNumber;

    /** 开户人 */
    private String                 openMan;

    /** 账号邮箱 */
    private String                 email;

    /** 账号类型 */
    private Integer                roleType;
    
    /** 媒体请款清单状态：0:未请款，1:已请款*/
    private Integer cashRequirementStatus;

    private String mediaAuditor;

    private Date mediaAuditTime;

    private String requireCashAuditor;

    private Date requireCashAuditTime;

    private Integer companyType;

    private Long cashAmount;

    private String flowAuditor;

    private Date flowAuditorTime;

    private String ceoAuditor;

    private Date ceoAuditorTime;

    /** 合同类型 */
    private Byte contractStatus;

    public String getFlowAuditor() {
        return flowAuditor;
    }

    public void setFlowAuditor(String flowAuditor) {
        this.flowAuditor = flowAuditor;
    }

    public Date getFlowAuditorTime() {
        return flowAuditorTime;
    }

    public void setFlowAuditorTime(Date flowAuditorTime) {
        this.flowAuditorTime = flowAuditorTime;
    }

    public String getCeoAuditor() {
        return ceoAuditor;
    }

    public void setCeoAuditor(String ceoAuditor) {
        this.ceoAuditor = ceoAuditor;
    }

    public Date getCeoAuditorTime() {
        return ceoAuditorTime;
    }

    public void setCeoAuditorTime(Date ceoAuditorTime) {
        this.ceoAuditorTime = ceoAuditorTime;
    }

    public Integer getCompanyType() {
        return companyType;
    }

    public void setCompanyType(Integer companyType) {
        this.companyType = companyType;
    }

    public String getMediaAuditor() {
        return mediaAuditor;
    }

    public void setMediaAuditor(String mediaAuditor) {
        this.mediaAuditor = mediaAuditor;
    }

    public Date getMediaAuditTime() {
        return mediaAuditTime;
    }

    public void setMediaAuditTime(Date mediaAuditTime) {
        this.mediaAuditTime = mediaAuditTime;
    }

    public String getRequireCashAuditor() {
        return requireCashAuditor;
    }

    public void setRequireCashAuditor(String requireCashAuditor) {
        this.requireCashAuditor = requireCashAuditor;
    }

    public Date getRequireCashAuditTime() {
        return requireCashAuditTime;
    }

    public void setRequireCashAuditTime(Date requireCashAuditTime) {
        this.requireCashAuditTime = requireCashAuditTime;
    }

    public Integer getNeedBackSettlement() {
        return needBackSettlement;
    }

    
    public void setNeedBackSettlement(Integer needBackSettlement) {
        this.needBackSettlement = needBackSettlement;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    public String getSenderAddr() {
        return senderAddr;
    }

    public void setSenderAddr(String senderAddr) {
        this.senderAddr = senderAddr;
    }

    public Integer getBillCount() {
        return billCount;
    }

    public void setBillCount(Integer billCount) {
        this.billCount = billCount;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getRefuseType() {
        return refuseType;
    }

    public void setRefuseType(Integer refuseType) {
        this.refuseType = refuseType;
    }

    public String getCheckMsg() {
        return checkMsg;
    }

    public void setCheckMsg(String checkMsg) {
        this.checkMsg = checkMsg;
    }

    public Integer getSendType() {
        return sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public List<MediaCashBillDto> getMediaCashBillDtos() {
        return mediaCashBillDtos;
    }

    public void setMediaCashBillDtos(List<MediaCashBillDto> mediaCashBillDtos) {
        this.mediaCashBillDtos = mediaCashBillDtos;
    }

    public Long getCashOrderId() {
        return cashOrderId;
    }

    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    public Long getFillInAmount() {
        return fillInAmount;
    }

    public void setFillInAmount(Long fillInAmount) {
        this.fillInAmount = fillInAmount;
    }
    
    /**
     * 获取提现订单状态文案
     * 
     * @param status 提现订单状态编码
     * @return 提现订单状态文案
     */
    public static String getStatusText(Integer status) {
        String text = "状态未定义";
        if (status != null) {
            switch (status) {
                case ORDER_CHECK_STATUS_AUDIT:
                    text = "待媒介负责人审核";
                    break;

                case ORDER_CHECK_STATUS_REFUSE:
                    text = "审核拒绝";
                    break;

                case ORDER_CHECK_STATUS_PASS:
                    text = "待打款";
                    break;
                 
                case ORDER_CHECK_STATUS_PLAYED:
                    text = "已打款";
                    break;

                case ORDER_CHECK_STATUS_REQUIRES_CASH:
                    text = "待请款";
                    break;

                case ORDER_CHECK_STATUS_FINANCE_AUDIT:
                    text = "待财务审核";
                    break;

                default:
                    break;
            }
        }
        return text;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getFinanceCompanyName() {
        return financeCompanyName;
    }

    public void setFinanceCompanyName(String financeCompanyName) {
        this.financeCompanyName = financeCompanyName;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getOpenMan() {
        return openMan;
    }

    public void setOpenMan(String openMan) {
        this.openMan = openMan;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getRoleType() {
        return roleType;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    public Byte getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Byte contractStatus) {
        this.contractStatus = contractStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    
    public Integer getCashRequirementStatus() {
        return cashRequirementStatus;
    }


    
    public void setCashRequirementStatus(Integer cashRequirementStatus) {
        this.cashRequirementStatus = cashRequirementStatus;
    }
    public Long getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(Long cashAmount) {
        this.cashAmount = cashAmount;
    }

}
