/**
 * Project Name:media-api File Name:ReqGetMediaAppConfigByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午2:59:53 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqGetMediaAppConfigByPageDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午2:59:53 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqGetMediaAppConfigByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = 6622615552013049824L;

    /** 按创建时间排序 */
    public static final String SORT_TYPE        = "gmt_create";

    /** 按降序排序 */
    public static final String ORDER_TYPE       = "desc";

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long               appId;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String             appName;

    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", required = false)
    private String             email;

    /** 审核状态 */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer            checkStatus;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间", required = false)
    private String             createDate;

    @ApiModelProperty(value = "线下打款状态位，0-非线下打款公司,1-线下打款公司")
    private Integer            isOffline;

    /** 媒体id列表 */
    private List<Long>         appIds;

    @ApiModelProperty(value = "标签id", required = false)
    private Long               tagId;

    /**用户类别*/
    @ApiModelProperty(value = "账号类别: 0-未选 1-直客 2-代理",required = false)
    private Integer accountType;

    /**平台类别*/
    @ApiModelProperty(value = "平台类别",required = false)
    private String platform;

    /** 媒体帐号ID*/
    @ApiModelProperty(value = "媒体帐号ID")
    private Long               mediaId;

    /** 合同状态*/
    @ApiModelProperty(value = "合同状态(1:待签署,2:已签署，3:已失效)",required = false)
    private Byte contractStatus;

    private Boolean cheat;


    public Byte getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(final Byte contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getPlatform() {
        return platform;
    }


    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }


    public Long getMediaId() {
        return mediaId;
    }


    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

	public Boolean getCheat() {
		return cheat;
	}

	public void setCheat(Boolean cheat) {
		this.cheat = cheat;
	}
}
