package cn.com.duiba.tuia.ssp.center.api.dto.mediumChangeNotice;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;

/**
 * 媒介变更通知
 */
public class MediumChangeNoticeDto extends BaseDto {
    /**
     * 媒体用户ID
     */
    private Long mediaId;

    /**
     * 媒介ID
     */
    private Long mediumId;

    /**
     * 媒介名称
     */
    private String mediumName;
    /**
     * 媒介电话
     */
    private String mediumPhoneNum;

    /**
     * 微信号
     */
    private String weChatNum;

    /**
     * 微信二维码
     */
    private String  weChatQRcode;

    /**
     * 通知类型 0-无负责人变更 1-有负责人变更
     */
    private Integer noticeType=1;

    /**
     * 媒介名字拼音
     */
    private String  mediumNamePinYin;

    public MediumChangeNoticeDto(Long mediumId, String mediumName, String mediumPhoneNum, String weChatNum, String weChatQRcode, String mediumNamePinYin) {
        this.mediumId = mediumId;
        this.mediumName = mediumName;
        this.mediumPhoneNum = mediumPhoneNum;
        this.weChatNum = weChatNum;
        this.weChatQRcode = weChatQRcode;
        this.mediumNamePinYin = mediumNamePinYin;
    }

    public MediumChangeNoticeDto() {
    }

    public MediumChangeNoticeDto(Long mediaId, Long mediumId) {
        this.mediaId = mediaId;
        this.mediumId = mediumId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getMediumId() {
        return mediumId;
    }

    public void setMediumId(Long mediumId) {
        this.mediumId = mediumId;
    }

    public String getMediumName() {
        return mediumName;
    }

    public void setMediumName(String mediumName) {
        this.mediumName = mediumName;
    }

    public String getMediumPhoneNum() {
        return mediumPhoneNum;
    }

    public void setMediumPhoneNum(String mediumPhoneNum) {
        this.mediumPhoneNum = mediumPhoneNum;
    }

    public String getWeChatNum() {
        return weChatNum;
    }

    public void setWeChatNum(String weChatNum) {
        this.weChatNum = weChatNum;
    }

    public String getWeChatQRcode() {
        return weChatQRcode;
    }

    public void setWeChatQRcode(String weChatQRcode) {
        this.weChatQRcode = weChatQRcode;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public String getMediumNamePinYin() {
        return mediumNamePinYin;
    }

    public void setMediumNamePinYin(String mediumNamePinYin) {
        this.mediumNamePinYin = mediumNamePinYin;
    }
}
