package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TagLibraryDto implements Serializable {
	
	private static final long serialVersionUID = -5431806212809784481L;

	private Long id;

    private String title;

    private Long pid;

    private Integer tagLevel;
    
    private List<TagLibraryDto> child;

    private Boolean isMediaUserPortraitTag;

    private Long activityId;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

	public List<TagLibraryDto> getChild() {
		return child;
	}

	public void setChild(List<TagLibraryDto> child) {
		this.child = child;
	}
	
	public void addChild(TagLibraryDto dto) {
		if(this.child == null){
			this.child = new ArrayList<>();
		}
		this.child.add(dto);
	}

	public Integer getTagLevel() {
		return tagLevel;
	}

	public void setTagLevel(Integer tagLevel) {
		this.tagLevel = tagLevel;
	}

    public Boolean getMediaUserPortraitTag() {
        return isMediaUserPortraitTag;
    }

    public void setMediaUserPortraitTag(Boolean mediaUserPortraitTag) {
        isMediaUserPortraitTag = mediaUserPortraitTag;
    }
}