package cn.com.duiba.tuia.ssp.center.api.remote.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.TagAdvertInfoDto;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.CanServeAdvertDto;
import cn.com.duiba.tuia.ssp.center.api.remote.media.enums.MaterialSwitchEnum;
import cn.com.duiba.tuia.ssp.center.api.remote.media.enums.ReviewTypeEnum;
import java.util.List;
import java.util.Map;

/**
 * 美团 RemoteService
 * @dateTime 2019-09-26 17:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemoteMeituanService {


    /**
     * 提交送审
     * @param advert 广告信息
     * @param typeEnum 类型枚举
     * @return 处理结果
     */
    boolean submitReview(TagAdvertInfoDto advert, ReviewTypeEnum typeEnum);

    /**
     * 素材开关
     * @param materialId 素材 Id
     * @param switchEnum 开关枚举
     * @return 处理结果
     */
    boolean materialSwitch(Long materialId, MaterialSwitchEnum switchEnum);

    /**
     * { 获取 } 可投放广告
     * @param slotId 广告位 Id
     * @return 处理结果
     */
    List<CanServeAdvertDto> canServeAdvert(Long slotId);

    /**
     * { 获取 } 可见广告
     * @param mediaId 媒体 Id
     * @return 处理结果
     */
    Map<Long, TagAdvertInfoDto> visibleAdvert(Long mediaId);

    /**
     * { 获取 } 创意 Id
     * 注: 美团 Adx 竞价出创意使用.
     * @param advertId 广告 Id
     * @param materialId 素材 Id
     * @return 处理结果
     */
    String selectByCreativeId(Long advertId, Long materialId);

}
