package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuantong
 *
 */
public enum TagEnum {

    OTHER((byte) 0, "兜底情况"),
    ONLY((byte) 1, "仅投活动"),
    PRIORITY_MANUAL((byte) 2, "优投手动配置部分"),
    PRIORITY_ALGO((byte) 3, "优投手动配置走完后走算法部分"),
    ALGO_HOT_ACTIVITY_PLAN((byte) 16, "算法切量"),
    AVTIVE_PLAN((byte) 20, "活动推广计划");

    public static final Map<String, Byte> TAG_TYPE_MAP;

    static {
        Map<String, Byte> temp = new HashMap<>(TagEnum.values().length, 1);
        for (TagEnum tag: TagEnum.values()) {
            temp.put(tag.name(), tag.getCode());
        }
        TAG_TYPE_MAP = Collections.unmodifiableMap(temp);
    }

    TagEnum(final Byte code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Byte getByteType(String value) {
        return TAG_TYPE_MAP.get(value);
    }


    private Byte code;
    private String desc;

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
