/**
 * Project Name:media-api<br>
 * File Name:RemoteSlotService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年9月30日下午4:21:08<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.algo.ActivityInfo;
import cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotInfo;
import cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotWhiteListStatusDto;
import cn.com.duiba.tuia.ssp.center.api.tool.idsquery.IdsQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName: RemoteSlotService <br/>
 * Function: 广告位. <br/>
 * date: 2016年9月30日 下午4:21:08 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteSlotBackendService {

    /**
     * 查询广告位详情.
     *
     * @param slotId 广告位id
     * @return 广告位详情
     */
    DubboResult<RspSlotBackendDetailDto> getDetail(Long slotId);

    /**
     * 更新广告位浮标和插件配置
     * @param plugBuoyConfigDto 浮标和插件信息，广告位信息必传，不能为空
     * @return 更新成功条数
     */
    DubboResult<Integer> updatePlugBuoyConfig(PlugBuoyConfigDto plugBuoyConfigDto);

    /**
     * 新增一条广告位浮标和插件配置
     * @param plugBuoyConfigDto  浮标和插件信息，广告位信息必传，不能为空
     * @return 更新插入成功条数
     */
    DubboResult<Integer> insertPlugBuoyConfig(PlugBuoyConfigDto plugBuoyConfigDto);
    
    /**
     * 查询广告位浮标和插件配置
     * @param slotId
     * @return
     */
    PlugBuoyConfigDto getPlugBuoyConfigDto(Long slotId);

    /**
     * 查询广告位对应的SDK信息
     * @param slotId
     * @return
     */
    DubboResult<List <SdkInfoDto>> getSdkInfo(Long slotId);

    /**
     * 查询广告位集合.
     *
     * @param slotIds the slot ids
     * @return the detail
     */
    DubboResult<List<SlotDto>> getListDetail(List<Long> slotIds);

    /**
     * 分页查询广告位数据.
     *
     * @param req the req
     * @return the slots by page
     */
    DubboResult<PageResultDto<RspAdsenseSlotListDto>> getSlotsByPage(ReqGetSlotsByPageDto req);

    /**
     * 更新广告位.
     *
     * @param param the param
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> update(ReqUpdateSlotStrategy param);

    /**
     * 查看广告选择类型参数
     * 
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<SlotTypeParamDto>> selectSlotTypeParam();

    /**
     * 修改广告部分属性
     * 
     * @param slotDto
     * @return boolean
     */
    DubboResult<Boolean> updateSlot(SlotDto slotDto);


    /**
     * 修改广告部分属性
     *
     * @param slotDto
     * @return boolean
     */
    Boolean updateSlotDistiinguishDeep(SlotDto slotDto, Map<String,Object> deepMap);

    /**
     * 通过广告位名称查询广告id集合
     * 
     * @param slotName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getSlotIdsByName(String slotName);

    /**
     * 删除缓存中的所有的广告id和名称
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> delAllSlotIdAndNameCache();

    /**
     * getSlotById:(通过广告位Id查询广告位详情). <br/>
     *
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<SlotDto> getSlotById(Long slotId);

    /**
     * getSlotByIdCache:(通过广告位ID查询缓存中的广告位对象信息). <br/>
     *
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<SlotCacheDto> getSlotByIdCache(Long slotId);

    /**
     * selectSlotByAppId:(根据appId获取app下所有广告位信息). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<SlotDto>> selectSlotByAppId(Long appId);

    /**
     * selectSlotConfigListByAppId:(根据appId获取app下所有广告位配置信息). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<SlotConfigDto>> selectSlotConfigListByAppId(Long appId);

    /**
     * updateSlotConfig:(更新广告位配置信息). <br/>
     *
     * @author ZFZ
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateSlotConfig(SlotConfigDto dto);

    /**
     *  从长期配置表同步
     * @return
     */
    DubboResult<Boolean> scheduleUpdateSlotConfig();

    DubboResult<SlotDto> insert(SlotDto record);

    DubboResult<List<SlotDto>> selectListByPage(ReqSlotList reqSlotList);

    DubboResult<Integer> updateDelStatus(Long slotId, Long mediaId);

    DubboResult<Integer> selectAmountByPage(ReqSlotList reqSlotList);

    DubboResult<List<IdAndNameDto>> selectIdsByMediaId4data(Long mediaId);

    /**
     * 根据媒体用户Id 查询广告位Id，不包含已经删除的广告位
     *
     * @param mediaId
     * @return
     */
    List<IdAndNameDto> selectIdsByMediaId(Long mediaId);

    DubboResult<List<SlotDto>> selectListByPage4data(ReqSlotList param);
    
    /**
     * 根据appId列表批量查询广告位信息
     * @param appIds
     * @return
     */
    DubboResult<List<SlotDto>> selectListByAppIds(List<Long> appIds);
    
    /**
     * 
     * 修改广告位表中的管理端屏蔽策略标签id
     *
     * @author guyan
     * @param slotId
     * @param managerStrategyId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateManagerStrategyById(Long slotId,Long managerStrategyId);


    DubboResult<List<SlotAndAppRsp>>  selectSlotAndAppName(SlotAndAppNameReq slotAndAppNameReq);
    
    
    /**
     * 
     * 修改广告位冻结原因
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateSlotFrozenStatus(ReqUpdateSlotStatusDto param);

    /**
     * 修改广告位缓存，业务端新增广告位时调用
     * @param slotId
     * @return
     */
    DubboResult<Boolean> updateSlotCache(Long slotId);

    DubboResult<Boolean> updateSoltIdAndNameCache(Long slotId);

    DubboResult<Integer> updateEnableStatus(Integer enableStatus, Long slotId);

    List<MediaAppSlotDto> selectMediaAppSlotList(ReqMediaAppSlot req);
    
    List<Long> listSlotIdsByPublicityId(Long publicityId);
    
    SlotConfigDto selectSlotConfigById(Long slotId);

    List<SlotConfigDto> selectSlotConfigByIds(List<Long> slotIds);

    /**
     * 更新广告位浮标和插件配置（无插件）
     * @param plugBuoyConfigDto 浮标和插件信息，广告位信息必传，不能为空
     * @return 更新成功条数
     */
    DubboResult<Integer> updatePlugBuoyConfig2(PlugBuoyConfigDto plugBuoyConfigDto);

    /**
     * 修改广告位的素材规格ID为null
     * @param slotId
     * @return
     */
    Integer updateSlotMsId(Long slotId);

    /**
     * 查询提升媒体收益的广告位数据
     *
     * @param mediaId
     * @return
     */
    List<SlotDto> selectMediaIncomeOptSlot(Long mediaId);

    Long getAnyoneSlotId(Long mediaId);

    /**
     * 查询广告位数据
     *
     * @param req
     * @return
     */
    List<SlotDto> selectSlotListByParam(ReqSlotList req);

    List<SlotAppId> selectSlotAppIds(IdsQueryParam idsQueryParam);

    List<SlotDto> listSlotDtoBySlotIds(IdsQueryParam idsQueryParam);

    /**
     * 更新广告位白名单状态
     * @param slotIds 广告位Id集合
     * @param openWhiteList 白名单标识
     * @return 更新数
     */
    Integer  updateOpenWhiteStatus(List<Long> slotIds, Integer openWhiteList);


    /**
     * 查询广告位id name
     *
     * @param req
     * @return
     */
    List<SlotIdAndNameDto> selectIdAndNameByParam(ReqSlotList req);

    /**
     * 过滤广告位白名单集合
     * @param slotIds 广告位ids
     * @return 开启白名单的集合
     */
    List<Long> filterOpenWhiteList(List<Long> slotIds);

    /**
     * 根据广告位id获取此广告位可投活动列表
     * @param slotId 广告位id
     * @return 广告位可投活动列表
     */
    List<ActivityInfo> listSlotCanAccessActivity(Long slotId);

    /**
     * 获取最近2小时的去重活跃广告位(排除id=0的广告位)
     * @return 去重后的活跃广告位集合
     */
    Set<Long> getRedisSlotList();

    /**
     * 获取开启素材算法PV分流的广告位ID列表
     * @return 开启素材PV分流的广告位ID列表
     */
    List<SlotInfo> getSckAlgoOpenSlotIds();

    /**
     * @Author zhangliwei
     * @Description  根据广告位ID查询屏蔽素材ID集合
     * @Date 11:21 2019-10-28
     * @Param [slotId]
     * @return java.util.List<java.lang.Long>
     **/
    List<Long> getSlotShieldMaterialIds(Long slotId);

    /**
     * @Author zhangliwei
     * @Description  批量插入广告位屏蔽素材列表
     * @Date 15:28 2019-10-28
     * @Param [slotSckShieldDtos]
     * @return java.lang.Boolean
     **/
    Boolean insertShieldBatch(List<SlotSckShieldDto> slotSckShieldDtos);


    /**
     * @Author zhangliwei
     * @Description  根据广告位ID和素材ID集合清空素材屏蔽表记录
     * @Date 16:29 2019-10-28
     * @Param [sckIds, slotId]
     * @return java.lang.Boolean
     **/
    Boolean deleteShieldsBySlotIdAndSckIds(List<Long> sckIds,Long slotId);

    /**
     * @Author zhangliwei
     * @Description  获取广告位白名单是否同步到流量策略功能
     * @Date 16:12 2019-11-12
     * @Param [slotId]
     * @return cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotWhiteListStatusDto
     **/
    SlotWhiteListStatusDto getSlotWhiteStatusById(Long slotId);
 }
