package cn.com.duiba.tuia.ssp.center.api.tool;

/**
 * 〈一句话介绍功能〉<br>
 * 堆栈跟踪工具类 提供一些公共方法
 * 目前只有获取当前调用方法名
 *
 * @author jierui on 18/10/30.
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class StackTraceUtil {

    /**
     * 获取执行getCurrentCallMethodName方法的当前方法方法名
     *
     * @return 返回执行调用getCurrentCallMethodName的方法名
     */
    @SuppressWarnings("unused")
    public static String getCurrentCallMethodName() {
        return getCallMethodName(1);
    }

    /**
     * 获取执行getCurrentCallMethodName方法的当前方法方法名
     *
     * @param depth 调用深度，调用getCallMethodName的方法深度为0, 每往上一层调用+1
     * @return 返回方法名
     */
    public static String getCallMethodName(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("depth must bigger than 0!");
        }

        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        if (2 + depth > stacks.length - 1) {
            return null;
        }
        return stacks[2 + depth].getMethodName();
    }
}
