package cn.com.duiba.tuia.ssp.center.api.remote.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.wechat.WeChatAccontDto;


/**
 * @author shenjiaqing
 * @description 微信公众号接口开发调用类
 * @data 2019/10/25
 */
@AdvancedFeignClient
public interface RemoteWeChatService {

    /**
     * 功能描述 开启微信通知
     * @author shenjiaqing
     * @date 11:48 2019/10/25
     * @param [openId]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Integer>
     **/
    Integer enableWeChatNotice(String openId);

    /**
     * 功能描述 是否开启微信通知
     * @author shenjiaqing
     * @date 13:04 2019/10/25
     * @param [openId]
     * @return java.lang.Integer
     **/
    Integer isEnableWeChatNotice(String openId);

    /**
     * 功能描述 是否绑定过微信号（如果>1，证明绑定过微信了，如果<1，证明没有绑定过微信或者解除微信）
     * @author shenjiaqing
     * @date 13:04 2019/10/25
     * @param [openId]
     * @return java.lang.Integer
     **/
    Integer isBindWeChat(String openId);

    /**
     * 功能描述 之前绑定过微信，并且解除绑定了
     * @author shenjiaqing
     * @date 15:47 2019/10/25
     * @param [openId]
     * @return java.lang.Integer
     **/
    Integer isEvenBindWeChat(String openId);

    /**
     * 功能描述 绑定微信号
     * @author shenjiaqing
     * @date 14:27 2019/10/25
     * @param [weChatAccontDto]
     * @return java.lang.Integer
     **/
    Integer weChatBind(WeChatAccontDto weChatAccontDto);

    /**
     * 功能描述 解除过绑定微信号，重新进行绑定
     * @author shenjiaqing
     * @date 16:02 2019/10/25
     * @param [weChatAccontDto]
     * @return java.lang.Integer
     **/
    Integer weChatBindAgain(WeChatAccontDto weChatAccontDto);

    /**
     * 功能描述 解除微信号绑定
     * @author shenjiaqing
     * @date 15:31 2019/10/25
     * @param [bizType, accountId]
     * @return java.lang.Integer
     **/
    Integer cancelWeChatBind(Integer bizType, Long accountId);

    /**
     * 功能描述 根据业务类型和提问人id获取提问人的openId
     * @author shenjiaqing
     * @date 17:04 2019/10/29
     * @param [bizType, accountId]
     * @return java.lang.String
     **/
    String selectOpenIdByUserId(Integer bizType, Long accountId);

    /**
     * 功能描述 是否绑定过微信，并且发送过信息
     * @author shenjiaqing
     * @date 12:00 2019/10/31
     * @param [openId]
     * @return java.lang.Integer
     **/
    Integer isBindAndSend(String openId);

    /**
     * 功能描述 修改已经发送过引导的用户发送状态为已发送
     * @author shenjiaqing
     * @date 12:08 2019/10/31
     * @param [openId]
     * @return java.lang.Integer
     **/
    Integer updateSendStatus(String openId);

    /**
     * 功能描述 根据openId获取mediaId
     * @author shenjiaqing
     * @date 14:38 2019/11/5
     * @param [openId]
     * @return java.lang.Long
     **/
    Long selectUserIdByOpenId(String openId);

}
