package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialActStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialSlotStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialStatistics;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialStatisticsBase;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSlotMaterialStatisticsDayService {
	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MaterialStatisticsDto>> selectMaterialStaticList(ReqMaterialStatistics req);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<Integer> selectMaterialStaticCount(ReqMaterialStatistics req);

    DubboResult<Integer> selectMaterialDayStaticCount(ReqMaterialStatisticsBase req);

    DubboResult<List<MaterialStatisticsDto>> selectMaterialDayStaticList(ReqMaterialStatisticsBase req);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<Integer> selectMaterialSlotStaticCount(ReqMaterialSlotStatistics req);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<MaterialStatisticsDto>> selectMaterialSlotStaticList(ReqMaterialSlotStatistics req);

    DubboResult<Integer> selectMaterialSlotDayStaticCount(ReqMaterialSlotStatistics req);

    DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialStatisList(ReqMaterialSlotStatistics req);

    DubboResult<Integer> selectSlotMaterialStatisCount(ReqMaterialSlotStatistics req);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
	DubboResult<List<MaterialStatisticsDto>> listMaterialStatis(ReqMaterialStatistics reqMaterialStatistics);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
	DubboResult<Integer> countMaterialStatis(ReqMaterialStatistics reqMaterialStatistics);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
	DubboResult<List<MaterialStatisticsDto>> listDayMaterialStatic(ReqMaterialStatisticsBase reqMaterialStatisticsBase);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
	DubboResult<Integer> countDayMaterialStatic(ReqMaterialStatisticsBase reqMaterialStatisticsBase);
	
	/**
	 * 
	 * selectSlotMaterialActStatis:(查询广告位素材活动维度数据). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialActStatis(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActStatisCount:(查询广告位素材活动维度数据数量). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> selectSlotMaterialActStatisCount(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActDailyStatis:(查询广告位素材活动维度每日数据). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<List<MaterialStatisticsDto>> selectSlotMaterialActDailyStatis(ReqMaterialActStatistics req);
	
	/**
	 * 
	 * selectSlotMaterialActDailyStatisCount:(查询广告位素材活动维度每日数据数量). <br/>
	 *
	 * @author guyan
	 * @param req
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<Integer> selectSlotMaterialActDailyStatisCount(ReqMaterialActStatistics req);

	@FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
	List<MaterialStatisticsDto> selectMaterialCTRDataListBySckIds(ReqMaterialStatistics reqMaterialStatistics);
}
