/**
 * Project Name:media-api File Name:ReqAccountMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年11月30日下午5:08:53 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import cn.com.duiba.tuia.ssp.center.api.constant.TimeConstant;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.hutool.core.date.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqAccountMonthReportDto <br/>
 * Function: 用户月报表分页dto. <br/>
 * Date: 2016年11月30日 下午5:08:53 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqAccountMonthReportByPage extends BaseQueryDto {

    private Logger logger = LoggerFactory.getLogger(ReqAccountMonthReportByPage.class);

    /** 序列号 */
    private static final long serialVersionUID = -7607047345088496835L;



    /** 结算状态 */
    @ApiModelProperty(value = "结算状态", required = false)
    private Integer           checkStatus;

    /** 审核状态 */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer           auditStatus;
    
    /** 媒体用户账号 */
    @ApiModelProperty(value = "媒体用户账号", required = false)
    private String            account;

    /** 媒体名称 */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** 媒体ID */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 当前日期 */
    @ApiModelProperty(value = "当前日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM")
    private String            currentDate;

    /** 账户类型：0-普通账户 1-线下打款账户 */
    @ApiModelProperty(value = "是否是线下打款账户", required = false)
    private Integer             isOffline;


    /** 开发者ID */
    @ApiModelProperty(value = "开发者ID", required = false)
    private Integer             mediaId;

    private String              conditionStr;

    /**用户类别*/
    @ApiModelProperty(value = "用户类别", required = false)
    private Integer accountType;
    
    /**媒体账户ids*/
    @ApiModelProperty(value = "媒体账户ids", required = false)
    private List<Long> mediaIds;
    /**媒体ids*/
    @ApiModelProperty(value = "媒体ids", required = false)
    private List<Long> appIds;
   
    @ApiModelProperty(value = "生成日期", required = false)
    @DateTimeFormat(pattern = "yyyy-MM")
    private String            gmtCreate;

    /* 0：非0月账单 1：0元月账单 1：全部 */
    @ApiModelProperty(value = "媒体应得收入", required = false)
    private int justlyShare;
    /**媒体ids*/
    @ApiModelProperty(value = "限制媒体ids(0元账单筛选)", required = false)
    private List<Long> limitAppIds;

    @ApiModelProperty(value = "预付款状态")
    private Integer preStatus;

    /** 客户类型 */
    @ApiModelProperty(value = "客户类型", required = false)
    private Integer clientType;

    private String startDate;

    private String endDate;


    /**
     * 没有生成cpc/cpm的月账单appIDS
     */
    private List<Long> noProducedCpcOrCpmAppIds;

    public List<Long> getLimitAppIds() {
        return limitAppIds;
    }

    public void setLimitAppIds(List<Long> limitAppIds) {
        this.limitAppIds = limitAppIds;
    }

    /**
     * currentDate.
     *
     * @return the currentDate
     * @since JDK 1.6
     */
    public String getCurrentDate() {
        return currentDate;
    }

    /**
     * currentDate.
     *
     * @param currentDate the currentDate to set
     * @since JDK 1.6
     */
    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    /**
     * account.
     *
     * @return the account
     * @since JDK 1.6
     */
    public String getAccount() {
        return account;
    }

    /**
     * account.
     *
     * @param account the account to set
     * @since JDK 1.6
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * auditStatus.
     *
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Integer getMediaId() {
        return mediaId;
    }

    public void setMediaId(Integer mediaId) {
        this.mediaId = mediaId;
    }

    public String getConditionStr() {
        return conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }
    
    public Integer getAccountType() {
        return accountType;
    }

    
    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    
    public List<Long> getMediaIds() {
        return mediaIds;
    }

    
    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }
    
    public List<Long> getAppIds() {
        return appIds;
    }

    
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }
    
    public String getGmtCreate() {
        return gmtCreate;
    }
    
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public int getJustlyShare() {
        return justlyShare;
    }

    public void setJustlyShare(int justlyShare) {
        this.justlyShare = justlyShare;
    }

    public Integer getPreStatus() {
        return preStatus;
    }

    public void setPreStatus(Integer preStatus) {
        this.preStatus = preStatus;
    }

    public List<Long> getNoProducedCpcOrCpmAppIds() {
        return noProducedCpcOrCpmAppIds;
    }

    public void setNoProducedCpcOrCpmAppIds(List<Long> noProducedCpcOrCpmAppIds) {
        this.noProducedCpcOrCpmAppIds = noProducedCpcOrCpmAppIds;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setStartOrEndDate(){
        if (StringUtils.isNotBlank(this.getCurrentDate())){
            Date date=DateUtils.getDayDate(this.getCurrentDate()+"-01");
            this.setStartDate(DateUtil.format(DateUtil.beginOfMonth(date),TimeConstant.YYYY_MM_DD));
            this.setEndDate(DateUtil.format(DateUtil.endOfMonth(date),TimeConstant.YYYY_MM_DD_HH_MM_SS));
            return;
        }
        if (StringUtils.isBlank(this.getCurrentDate()) && StringUtils.isNotBlank(this.getGmtCreate())){
            Date date=DateUtils.monthsAddOrSub(DateUtils.getDayDate(this.getGmtCreate()+"-01"),-1);
            this.setStartDate(DateUtil.format(date,TimeConstant.YYYY_MM_DD));
            this.setEndDate(DateUtil.format(DateUtil.endOfMonth(date),TimeConstant.YYYY_MM_DD_HH_MM_SS));
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
