package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
@Data
public class SdkCrashLogDTO implements Serializable {
    private Long id;

    @FieldCheck(notNull = true)
    @JSONField(name = "app_id")
    private Long appId;

    private String imei;

    private String idfa;

    private String oaid;

    @FieldCheck(notEmpty = true)
    @JSONField(name = "device_id")
    private String deviceId;

    @FieldCheck(notEmpty = true)
    @JSONField(name = "sdk_version")
    private String sdkVersion;

    @FieldCheck(notEmpty = true)
    @JSONField(name = "phone_brand")
    private String phoneBrand;

    @FieldCheck(notEmpty = true)
    @JSONField(name = "phone_model")
    private String phoneModel;

    // 系统版本
    @FieldCheck(notEmpty = true)
    @JSONField(name = "os_version")
    private String osVersion;

    // 系统型号
    @FieldCheck(notEmpty = true)
    @JSONField(name = "os_type")
    private String osType;

    // 包名
    @FieldCheck(notEmpty = true)
    @JSONField(name = "package_name")
    private String packageName;

    /**
     * 处理状态：1-已处理 2-未处理 3-不可处理 9-其他
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.enums.SdkCrashLogStatusEnum}
     */
    @FieldCheck(notNull = true)
    private Integer status;

    // 崩溃日志
    @FieldCheck(notEmpty = true)
    @JSONField(name = "crash_logs")
    private String crashLogs;

    private Date gmtCreate;

    private Date gmtModified;
}