/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class FieldCheckUtils {
    private static final String NOT_EMPTY = "[%s]\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String NOT_NUll = "[%s]\u4e0d\u80fd\u4e3aNull";
    private static final String MAX_LENGTH = "[%s]\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%d";
    private static final String REGEX = "[%s]\u683c\u5f0f\u4e0d\u6b63\u786e";

    public static void checkFailFast(Object obj) {
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        if (declaredFields.length <= 0) {
            return;
        }
        for (Field field : declaredFields) {
            FieldCheckUtils.checkField(field, obj);
        }
    }

    public static void checkArrayFailFast(List<?> objects) {
        for (Object object : objects) {
            FieldCheckUtils.checkFailFast(object);
        }
    }

    public static void checkAll(Object obj) {
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        if (declaredFields.length <= 0) {
            return;
        }
        ArrayList<IllegalArgumentException> exceptionList = new ArrayList<IllegalArgumentException>();
        for (Field field : declaredFields) {
            try {
                FieldCheckUtils.checkField(field, obj);
            }
            catch (IllegalArgumentException e) {
                exceptionList.add(e);
            }
        }
        if (exceptionList.size() > 0) {
            throw new IllegalArgumentException(FieldCheckUtils.joinExceptionMessage(exceptionList));
        }
    }

    private static void checkField(Field field, Object obj) {
        FieldCheck fieldCheck = field.getAnnotation(FieldCheck.class);
        if (fieldCheck == null) {
            return;
        }
        String fieldName = fieldCheck.name();
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            fieldName = field.getName();
        }
        Object fieldValue = null;
        try {
            fieldValue = FieldCheckUtils.getValue(field, obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("[" + fieldName + "]\u503c\u83b7\u53d6\u5f02\u5e38", e);
        }
        if (fieldCheck.notEmpty()) {
            FieldCheckUtils.notEmpty(fieldValue, fieldName);
        } else if (fieldCheck.notNull()) {
            FieldCheckUtils.notNull(fieldValue, fieldName);
        }
        if (fieldCheck.maxLength() > 0) {
            FieldCheckUtils.maxLength(fieldValue, fieldName, fieldCheck.maxLength());
        }
        if (fieldCheck.regex() != null && fieldCheck.regex().length() > 0) {
            FieldCheckUtils.regex(fieldValue, fieldName, fieldCheck.regex());
        }
    }

    private static void notEmpty(Object fieldValue, String fieldName) {
        Assert.notNull((Object)fieldValue, (String)String.format(NOT_EMPTY, fieldName));
        if (fieldValue instanceof String) {
            Assert.hasText((String)((String)fieldValue), (String)String.format(NOT_EMPTY, fieldName));
        } else if (fieldValue instanceof Object[]) {
            Assert.notEmpty((Object[])((Object[])fieldValue), (String)String.format(NOT_EMPTY, fieldName));
        } else if (fieldValue instanceof Collection) {
            Assert.notEmpty((Collection)((Collection)fieldValue), (String)String.format(NOT_EMPTY, fieldName));
        } else if (fieldValue instanceof Map) {
            Assert.notEmpty((Map)((Map)fieldValue), (String)String.format(NOT_EMPTY, fieldName));
        }
    }

    private static void notNull(Object fieldValue, String fieldName) {
        Assert.notNull((Object)fieldValue, (String)String.format(NOT_NUll, fieldName));
    }

    private static void maxLength(Object fieldValue, String fieldName, int maxLength) {
        if (fieldValue != null && fieldValue instanceof CharSequence) {
            Assert.isTrue((((CharSequence)fieldValue).length() <= maxLength ? 1 : 0) != 0, (String)String.format(MAX_LENGTH, fieldName, maxLength));
        }
    }

    private static void regex(Object fieldValue, String fieldName, String regex) {
        if (fieldValue != null && fieldValue instanceof CharSequence) {
            boolean matched = Pattern.compile(regex).matcher((CharSequence)fieldValue).find();
            Assert.isTrue((boolean)matched, (String)String.format(REGEX, fieldName));
        }
    }

    private static Object getValue(Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        return field.get(obj);
    }

    private static String joinExceptionMessage(List<IllegalArgumentException> exceptionList) {
        StringBuilder exceptionMsg = new StringBuilder();
        for (IllegalArgumentException exception : exceptionList) {
            exceptionMsg.append(exception.getMessage()).append(";");
        }
        return exceptionMsg.toString();
    }

    public static void main(String[] args) {
        Test test = FieldCheckUtils.createTest();
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setAge(null);
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setName(null);
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setContext("01234567891");
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setObjArray(new Object[0]);
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setPeriod("6");
        FieldCheckUtils.checkAndPrint(test);
        test = FieldCheckUtils.createTest();
        test.setAge(null);
        test.setName(null);
        test.setContext("01234567891");
        test.setObjArray(new Object[0]);
        test.setPeriod("6");
        FieldCheckUtils.checkAll(test);
    }

    private static Test createTest() {
        Test test = new Test();
        test.setAge(1);
        test.setName("zixiao");
        test.setContext("0123456789");
        test.setObjArray(new Object[1]);
        test.setPeriod("M012");
        return test;
    }

    private static void checkAndPrint(Test test) {
        try {
            FieldCheckUtils.checkFailFast(test);
            System.out.println("\u6240\u6709\u5b57\u6bb5\u68c0\u67e5\u901a\u8fc7.");
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String toChineseString(Object obj) {
        JavaBeanSerializer javaBeanSerializer = new JavaBeanSerializer(obj.getClass());
        Map values = null;
        try {
            values = javaBeanSerializer.getFieldValuesMap(obj);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        if (declaredFields.length <= 0) {
            return "";
        }
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                FieldCheck f = field.getAnnotation(FieldCheck.class);
                if (f == null || values.get(field.getName()) == null) continue;
                sb.append(f.name());
                sb.append("=");
                Object val = values.get(field.getName());
                if (val instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    val = sdf.format((Date)val);
                }
                sb.append(val);
                sb.append(",");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return FieldCheckUtils.toString(sb);
    }

    private static String toString(StringBuffer sb) {
        if (sb.toString().length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        return "";
    }

    private static class Test {
        @FieldCheck(name="\u540d\u5b57", notEmpty=true)
        private String name;
        @FieldCheck(name="\u5e74\u9f84", notNull=true)
        private Integer age;
        @FieldCheck(name="\u5185\u5bb9", notEmpty=true, maxLength=10)
        private String context;
        @FieldCheck(name="\u5bf9\u8c61\u6570\u7ec4", notEmpty=true)
        private Object[] objArray;
        @FieldCheck(name="\u671f\u9650", notEmpty=true, regex="^[DMY][0-9]{3}$")
        private String period;

        private Test() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setObjArray(Object[] objArray) {
            this.objArray = objArray;
        }

        public void setPeriod(String period) {
            this.period = period;
        }
    }
}

