package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashLogDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashLogDetailDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashOverviewDTO;
import cn.com.duiba.tuia.ssp.center.api.query.SdkCrashLogQuery;

/**
 * @author K. L. Mao
 * @create 2019-12-30
 */
@AdvancedFeignClient
public interface RemoteSdkCrashLogService {

    /**
     * 插入崩溃日志
     * @param sdkCrashLogDTO
     * @return
     */
    Result<Void> insertSdkCrashLog(SdkCrashLogDTO sdkCrashLogDTO);

    /**
     * 崩溃日志列表
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkCrashLogDTO>> listSdkCrashLog(SdkCrashLogQuery crashLogQuery);

    /**
     * 已解决操作
     * @param sdkLogId
     * @return
     */
    Result<Void> resolveAction(Long sdkLogId);

    /**
     * 崩溃日志详情
     * @param sdkLogId
     * @return
     */
    Result<SdkCrashLogDetailDTO> sdkCrashLogDetail(Long sdkLogId);

    /**
     * 异常概述
     * @param crashLogQuery
     * @return
     */
    Result<SdkCrashOverviewDTO> overview(SdkCrashLogQuery crashLogQuery);

}
